/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class BookmarkLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image image;
    static final int COLUMN_ICON = 0;
    static final int COLUMN_DESCRIPTION = 1;
    static final int COLUMN_RESOURCE = 2;
    static final int COLUMN_FOLDER = 3;
    static final int COLUMN_LOCATION = 4;

    public BookmarkLabelProvider(BookmarkNavigator view) {
        ImageDescriptor desc = view.getImageDescriptor("obj16/bkmrk_tsk.gif");
        this.image = desc.createImage();
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public Image getImage(Object element) {
        return this.image;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof IMarker)) {
            return "";
        }
        IMarker marker = (IMarker)element;
        switch (columnIndex) {
            case 1: {
                return marker.getAttribute("message", "");
            }
            case 2: {
                return marker.getResource().getName();
            }
            case 3: {
                return BookmarkLabelProvider.getContainerName(marker);
            }
            case 4: {
                int line = marker.getAttribute("lineNumber", -1);
                if (line == -1) {
                    return "";
                }
                return BookmarkMessages.format("LineIndicator.text", new String[]{String.valueOf(line)});
            }
        }
        return "";
    }

    public Image getColumnImage(Object element, int index) {
        if (index == 0) {
            return this.image;
        }
        return null;
    }

    public static String getContainerName(IMarker marker) {
        IPath path = marker.getResource().getFullPath();
        int n = path.segmentCount() - 1;
        if (n <= 0) {
            return "";
        }
        int len = 0;
        for (int i = 0; i < n; ++i) {
            len += path.segment(i).length();
        }
        if (n > 1) {
            len += n - 1;
        }
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sb.append('/');
            }
            sb.append(path.segment(i));
        }
        return sb.toString();
    }
}

