/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.TypeInfo;

public class JarFileEntryTypeInfo
extends TypeInfo {
    private final String fJar;
    private final String fFileName;
    private final String fExtension;

    public JarFileEntryTypeInfo(String pkg, String name, char[][] enclosingTypes, boolean isInterface, String jar, String fileName, String extension) {
        super(pkg, name, enclosingTypes, isInterface);
        this.fJar = jar;
        this.fFileName = fileName;
        this.fExtension = extension;
    }

    public int getElementType() {
        return 2;
    }

    public String getJar() {
        return this.fJar;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public String getExtension() {
        return this.fExtension;
    }

    protected IJavaElement getJavaElement(IJavaSearchScope scope) throws JavaModelException {
        IJavaModel jmodel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IPath[] enclosedPaths = scope.enclosingProjectsAndJars();
        for (int i = 0; i < enclosedPaths.length; ++i) {
            IJavaProject jproject;
            IPackageFragmentRoot root;
            IPath curr = enclosedPaths[i];
            if (curr.segmentCount() != 1 || !(root = (jproject = jmodel.getJavaProject(curr.segment(0))).getPackageFragmentRoot(this.fJar)).exists()) continue;
            return this.findElementInRoot(root);
        }
        List<IPath> paths = Arrays.asList(enclosedPaths);
        IJavaProject[] projects = jmodel.getJavaProjects();
        for (int i = 0; i < projects.length; ++i) {
            IPackageFragmentRoot root;
            IJavaProject jproject = projects[i];
            if (paths.contains(jproject.getPath()) || !(root = jproject.getPackageFragmentRoot(this.fJar)).exists()) continue;
            return this.findElementInRoot(root);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private IJavaElement findElementInRoot(IPackageFragmentRoot root) {
        void var2_4;
        IClassFile res;
        IPackageFragment frag = root.getPackageFragment(this.getPackageName());
        String extension = this.getExtension();
        if ("class".equals(extension)) {
            res = frag.getClassFile(this.getFileName() + ".class");
        } else if ("java".equals(extension)) {
            res = frag.getCompilationUnit(this.getFileName() + ".java");
        } else {
            return null;
        }
        if (var2_4.exists()) {
            return var2_4;
        }
        return null;
    }

    public IPath getPackageFragmentRootPath() {
        return new Path(this.fJar);
    }

    public String getPath() {
        StringBuffer result = new StringBuffer(this.fJar);
        result.append("|");
        this.getElementPath(result);
        return result.toString();
    }

    private void getElementPath(StringBuffer result) {
        String pack = this.getPackageName();
        if (pack != null && pack.length() > 0) {
            result.append(pack.replace('.', '/'));
            result.append('/');
        }
        result.append(this.getFileName());
        result.append('.');
        result.append(this.getExtension());
    }
}

