/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.jdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.jdt.internal.ui.dnd.TransferDragSourceListener;
import org.eclipse.jdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.jdt.internal.ui.filters.OutputFolderFilter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jdt.internal.ui.packageview.FileTransferDragAdapter;
import org.eclipse.jdt.internal.ui.packageview.FileTransferDropAdapter;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerActionGroup;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.jdt.internal.ui.packageview.SelectionTransferDropAdapter;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.jdt.internal.ui.util.JavaUIHelp;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.FilterUpdater;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class PackageExplorerPart
extends ViewPart
implements ISetSelectionTarget,
IMenuListener,
IShowInTarget,
IPackagesViewPart,
IPropertyChangeListener,
IViewPartInputProvider {
    private boolean fIsCurrentLayoutFlat;
    private static final int HIERARCHICAL_LAYOUT = 1;
    private static final int FLAT_LAYOUT = 2;
    public static final String VIEW_ID = "org.eclipse.jdt.ui.PackageExplorer";
    static final String TAG_SELECTION = "selection";
    static final String TAG_EXPANDED = "expanded";
    static final String TAG_ELEMENT = "element";
    static final String TAG_PATH = "path";
    static final String TAG_VERTICAL_POSITION = "verticalPosition";
    static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    static final String TAG_FILTERS = "filters";
    static final String TAG_FILTER = "filter";
    static final String TAG_LAYOUT = "layout";
    static final String TAG_CURRENT_FRAME = "currentFramge";
    private PackageExplorerContentProvider fContentProvider;
    private FilterUpdater fFilterUpdater;
    private PackageExplorerActionGroup fActionSet;
    private ProblemTreeViewer fViewer;
    private Menu fContextMenu;
    private IMemento fMemento;
    private ISelectionChangedListener fSelectionListener;
    private String fWorkingSetName;
    private IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                PackageExplorerPart.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private ITreeViewerListener fExpansionListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Object element = event.getElement();
            if (element instanceof ICompilationUnit || element instanceof IClassFile) {
                PackageExplorerPart.this.expandMainType(element);
            }
        }
    };
    private PackageExplorerLabelProvider fLabelProvider;
    private boolean fLinkingEnabled;
    static /* synthetic */ Class class$org$eclipse$jface$viewers$ISelectionProvider;
    static /* synthetic */ Class class$org$eclipse$ui$part$IShowInSource;
    static /* synthetic */ Class class$org$eclipse$ui$part$IShowInTargetList;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
        this.restoreLayoutState(memento);
    }

    private void restoreLayoutState(IMemento memento) {
        Integer state = null;
        if (memento != null) {
            state = memento.getInteger(TAG_LAYOUT);
        }
        if (state == null) {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            state = new Integer(store.getInt(TAG_LAYOUT));
        }
        this.fIsCurrentLayoutFlat = state == 2 ? true : state != 1;
    }

    public static PackageExplorerPart getFromActivePerspective() {
        IWorkbenchPage activePage = JavaPlugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart view = activePage.findView(VIEW_ID);
        if (view instanceof PackageExplorerPart) {
            return (PackageExplorerPart)view;
        }
        return null;
    }

    public static PackageExplorerPart openInActivePerspective() {
        try {
            return (PackageExplorerPart)JavaPlugin.getActivePage().showView(VIEW_ID);
        }
        catch (PartInitException pe) {
            return null;
        }
    }

    public void dispose() {
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        this.getSite().getPage().removePartListener(this.fPartListener);
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fViewer != null) {
            this.fViewer.removeTreeListener(this.fExpansionListener);
        }
        if (this.fActionSet != null) {
            this.fActionSet.dispose();
        }
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.fViewer = this.createViewer(parent);
        this.fViewer.setUseHashlookup(true);
        this.initDragAndDrop();
        this.setProviders();
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
        site.getPage().addPartListener(this.fPartListener);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.makeActions();
        this.restoreFilterAndSorter();
        this.fViewer.setInput(this.findInputElement());
        this.initFrameActions();
        this.initKeyListener();
        this.fViewer.addPostSelectionChangedListener(this.fSelectionListener);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PackageExplorerPart.this.fActionSet.handleDoubleClick(event);
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                PackageExplorerPart.this.fActionSet.handleOpen(event);
            }
        });
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.fViewer.addTreeListener(this.fExpansionListener);
        if (this.fMemento != null) {
            this.restoreUIState(this.fMemento);
        }
        this.fMemento = null;
        JavaUIHelp.setHelp((StructuredViewer)this.fViewer, "org.eclipse.jdt.ui.package_view_context");
        this.fillActionBars();
        this.updateTitle();
        this.fFilterUpdater = new FilterUpdater((StructuredViewer)this.fViewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
    }

    private void initFrameActions() {
        this.fActionSet.getUpAction().update();
        this.fActionSet.getBackAction().update();
        this.fActionSet.getForwardAction().update();
    }

    private ProblemTreeViewer createViewer(Composite composite) {
        return new PackageExplorerProblemTreeViewer(composite, 770);
    }

    boolean isFlatLayout() {
        return this.fIsCurrentLayoutFlat;
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        this.fContentProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = this.createLabelProvider();
        this.fLabelProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(this.fLabelProvider, false));
    }

    void toggleLayout() {
        this.fIsCurrentLayoutFlat = !this.fIsCurrentLayoutFlat;
        this.saveLayoutState(null);
        this.fContentProvider.setIsFlatLayout(this.isFlatLayout());
        this.fLabelProvider.setIsFlatLayout(this.isFlatLayout());
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.refresh();
        this.fViewer.getControl().setRedraw(true);
    }

    public PackageExplorerContentProvider createContentProvider() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("org.eclipse.jdt.ui.packages.cuchildren");
        return new PackageExplorerContentProvider(this, showCUChildren);
    }

    private PackageExplorerLabelProvider createLabelProvider() {
        return new PackageExplorerLabelProvider(1627389961, 3, this.fContentProvider);
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fActionSet.fillActionBars(actionBars);
    }

    private Object findInputElement() {
        IAdaptable input = this.getSite().getPage().getInput();
        if (input instanceof IWorkspace) {
            return JavaCore.create((IWorkspaceRoot)((IWorkspace)input).getRoot());
        }
        if (input instanceof IContainer) {
            IJavaElement element = JavaCore.create((IResource)((IContainer)input));
            if (element != null && element.exists()) {
                return element;
            }
            return input;
        }
        return JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot());
    }

    public Object getAdapter(Class key) {
        if (key.equals(class$org$eclipse$jface$viewers$ISelectionProvider == null ? (class$org$eclipse$jface$viewers$ISelectionProvider = PackageExplorerPart.class$("org.eclipse.jface.viewers.ISelectionProvider")) : class$org$eclipse$jface$viewers$ISelectionProvider)) {
            return this.fViewer;
        }
        if (key == (class$org$eclipse$ui$part$IShowInSource == null ? (class$org$eclipse$ui$part$IShowInSource = PackageExplorerPart.class$("org.eclipse.ui.part.IShowInSource")) : class$org$eclipse$ui$part$IShowInSource)) {
            return this.getShowInSource();
        }
        if (key == (class$org$eclipse$ui$part$IShowInTargetList == null ? (class$org$eclipse$ui$part$IShowInTargetList = PackageExplorerPart.class$("org.eclipse.ui.part.IShowInTargetList")) : class$org$eclipse$ui$part$IShowInTargetList)) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof IJavaModel ? PackagesMessages.getString("PackageExplorerPart.workspace") : JavaElementLabels.getTextLabel(element, 1090519049)) : ((path = ((IResource)element).getFullPath()).isRoot() ? PackagesMessages.getString("PackageExplorer.title") : path.makeRelative().toString());
        if (this.fWorkingSetName == null) {
            return result;
        }
        String wsstr = PackagesMessages.getFormattedString("PackageExplorer.toolTip", new String[]{this.fWorkingSetName});
        if (result.length() == 0) {
            return wsstr;
        }
        return PackagesMessages.getFormattedString("PackageExplorer.toolTip2", new String[]{result, this.fWorkingSetName});
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    private ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    public void menuAboutToShow(IMenuManager menu) {
        JavaPlugin.createStandardGroups(menu);
        this.fActionSet.setContext(new ActionContext(this.getSelection()));
        this.fActionSet.fillContextMenu(menu);
        this.fActionSet.setContext(null);
    }

    private void makeActions() {
        this.fActionSet = new PackageExplorerActionGroup(this);
    }

    private void initDragAndDrop() {
        this.initDrag();
        this.initDrop();
    }

    private void initDrag() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)this.fViewer), new ResourceTransferDragAdapter((ISelectionProvider)this.fViewer), new FileTransferDragAdapter((ISelectionProvider)this.fViewer)};
        this.fViewer.addDragSupport(ops, transfers, new JdtViewerDragAdapter((StructuredViewer)this.fViewer, dragListeners));
    }

    private void initDrop() {
        int ops = 23;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDropTargetListener[] dropListeners = new TransferDropTargetListener[]{new SelectionTransferDropAdapter((StructuredViewer)this.fViewer), new FileTransferDropAdapter((AbstractTreeViewer)this.fViewer)};
        this.fViewer.addDropSupport(ops, transfers, new DelegatingDropAdapter(dropListeners));
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.fActionSet.handleSelectionChanged(event);
        if (this.isLinkingEnabled()) {
            this.linkToEditor(selection);
        }
    }

    public void selectReveal(ISelection selection) {
        this.selectReveal(selection, 0);
    }

    private void selectReveal(final ISelection selection, final int count) {
        Control ctrl = this.getViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        ISelection javaSelection = this.convertSelection(selection);
        this.fViewer.setSelection(javaSelection, true);
        PackageExplorerContentProvider provider = (PackageExplorerContentProvider)this.getViewer().getContentProvider();
        ISelection cs = this.fViewer.getSelection();
        if (count == 0 && provider.hasPendingChanges() && !javaSelection.equals(cs)) {
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PackageExplorerPart.this.selectReveal(selection, count + 1);
                }
            });
        }
    }

    private ISelection convertSelection(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return s;
        }
        Object[] elements = ((StructuredSelection)s).toArray();
        if (!this.containsResources(elements)) {
            return s;
        }
        for (int i = 0; i < elements.length; ++i) {
            IResource r;
            Object o = elements[i];
            if (o instanceof IJavaElement) continue;
            if (o instanceof IResource) {
                IJavaElement jElement = JavaCore.create((IResource)((IResource)o));
                if (jElement == null || !jElement.exists()) continue;
                elements[i] = jElement;
                continue;
            }
            if (!(o instanceof IAdaptable) || (r = (IResource)((IAdaptable)o).getAdapter(class$org$eclipse$core$resources$IResource == null ? PackageExplorerPart.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource)) == null) continue;
            IJavaElement jElement = JavaCore.create((IResource)r);
            elements[i] = jElement != null && jElement.exists() ? jElement : r;
        }
        return new StructuredSelection(elements);
    }

    private boolean containsResources(Object[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            Object o = elements[i];
            if (o instanceof IJavaElement) continue;
            if (o instanceof IResource) {
                return true;
            }
            if (!(o instanceof IAdaptable) || ((IAdaptable)o).getAdapter(class$org$eclipse$core$resources$IResource == null ? PackageExplorerPart.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource) == null) continue;
            return true;
        }
        return false;
    }

    public void selectAndReveal(Object element) {
        this.selectReveal((ISelection)new StructuredSelection(element));
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void initLinkingEnabled() {
        this.fLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.packages.linktoeditor");
    }

    private void linkToEditor(IStructuredSelection selection) {
        IEditorPart part;
        if (!this.isActivePart()) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (selection.size() == 1 && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof IJavaElement) {
                EditorUtility.revealInEditor(part, (IJavaElement)obj);
            }
        }
    }

    private boolean isActivePart() {
        return this == this.getSite().getPage().getActivePart();
    }

    public void saveState(IMemento memento) {
        if (this.fViewer == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        this.saveCurrentFrame(memento);
        this.saveLayoutState(memento);
        this.saveLinkingEnabled(memento);
        this.fActionSet.saveFilterAndSorterState(memento);
    }

    private void saveCurrentFrame(IMemento memento) {
        FrameAction action = this.fActionSet.getUpAction();
        FrameList frameList = action.getFrameList();
        if (frameList.getCurrentIndex() > 0) {
            TreeFrame currentFrame = (TreeFrame)frameList.getCurrentFrame();
            IMemento frameMemento = memento.createChild(TAG_CURRENT_FRAME);
            currentFrame.saveState(frameMemento);
        }
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger("org.eclipse.jdt.ui.packages.linktoeditor", this.fLinkingEnabled ? 1 : 0);
    }

    private void saveLayoutState(IMemento memento) {
        if (memento != null) {
            memento.putInteger(TAG_LAYOUT, this.getLayoutAsInt());
        } else {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            store.setValue(TAG_LAYOUT, this.getLayoutAsInt());
        }
    }

    private int getLayoutAsInt() {
        if (this.fIsCurrentLayoutFlat) {
            return 2;
        }
        return 1;
    }

    protected void saveScrollState(IMemento memento, Tree tree) {
        ScrollBar bar = tree.getVerticalBar();
        int position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_VERTICAL_POSITION, String.valueOf(position));
        bar = tree.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_HORIZONTAL_POSITION, String.valueOf(position));
    }

    protected void saveSelectionState(IMemento memento) {
        Object[] elements = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        if (elements.length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTION);
            for (int i = 0; i < elements.length; ++i) {
                IMemento elementMem = selectionMem.createChild(TAG_ELEMENT);
                Object o = elements[i];
                if (!(o instanceof IJavaElement)) continue;
                elementMem.putString(TAG_PATH, ((IJavaElement)elements[i]).getHandleIdentifier());
            }
        }
    }

    protected void saveExpansionState(IMemento memento) {
        Object[] expandedElements = this.fViewer.getVisibleExpandedElements();
        if (expandedElements.length > 0) {
            IMemento expandedMem = memento.createChild(TAG_EXPANDED);
            for (int i = 0; i < expandedElements.length; ++i) {
                IMemento elementMem = expandedMem.createChild(TAG_ELEMENT);
                Object o = expandedElements[i];
                if (!(o instanceof IJavaElement)) continue;
                elementMem.putString(TAG_PATH, ((IJavaElement)expandedElements[i]).getHandleIdentifier());
            }
        }
    }

    private void restoreFilterAndSorter() {
        this.fViewer.addFilter(new OutputFolderFilter());
        this.fViewer.setSorter(new JavaElementSorter());
        if (this.fMemento != null) {
            this.fActionSet.restoreFilterAndSorterState(this.fMemento);
        }
    }

    private void restoreUIState(IMemento memento) {
        this.restoreCurrentFrame(memento);
    }

    private void restoreCurrentFrame(IMemento memento) {
        IMemento frameMemento = memento.getChild(TAG_CURRENT_FRAME);
        if (frameMemento != null) {
            FrameAction action = this.fActionSet.getUpAction();
            FrameList frameList = action.getFrameList();
            TreeFrame frame = new TreeFrame((AbstractTreeViewer)this.fViewer);
            frame.restoreState(frameMemento);
            frame.setName(this.getFrameName(frame.getInput()));
            frame.setToolTipText(this.getToolTipText(frame.getInput()));
            frameList.gotoFrame((Frame)frame);
        }
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger("org.eclipse.jdt.ui.packages.linktoeditor");
        if (val != null) {
            this.fLinkingEnabled = val != 0;
        }
    }

    protected void restoreScrollState(IMemento memento, Tree tree) {
        int position;
        String posStr;
        ScrollBar bar = tree.getVerticalBar();
        if (bar != null) {
            try {
                posStr = memento.getString(TAG_VERTICAL_POSITION);
                position = new Integer(posStr);
                bar.setSelection(position);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((bar = tree.getHorizontalBar()) != null) {
            try {
                posStr = memento.getString(TAG_HORIZONTAL_POSITION);
                position = new Integer(posStr);
                bar.setSelection(position);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    protected void restoreSelectionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_SELECTION);
        if (childMem != null) {
            ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
            IMemento[] elementMem = childMem.getChildren(TAG_ELEMENT);
            for (int i = 0; i < elementMem.length; ++i) {
                IJavaElement element = JavaCore.create((String)elementMem[i].getString(TAG_PATH));
                if (element == null) continue;
                list.add(element);
            }
            this.fViewer.setSelection((ISelection)new StructuredSelection(list));
        }
    }

    protected void restoreExpansionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_EXPANDED);
        if (childMem != null) {
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            IMemento[] elementMem = childMem.getChildren(TAG_ELEMENT);
            for (int i = 0; i < elementMem.length; ++i) {
                IJavaElement element = JavaCore.create((String)elementMem[i].getString(TAG_PATH));
                if (element == null) continue;
                elements.add(element);
            }
            this.fViewer.setExpandedElements(elements.toArray());
        }
    }

    private void initKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                PackageExplorerPart.this.fActionSet.handleKeyEvent(event);
            }
        });
    }

    void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        Object input = this.getElementOfInput(editor.getEditorInput());
        if (input == null) {
            return;
        }
        if (!this.inputIsSelected(editor.getEditorInput())) {
            this.showInput(input);
        } else {
            this.getTreeViewer().getTree().showSelection();
        }
    }

    private boolean inputIsSelected(IEditorInput input) {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.size() != 1) {
            return false;
        }
        IEditorInput selectionAsInput = null;
        try {
            selectionAsInput = EditorUtility.getEditorInput(selection.getFirstElement());
        }
        catch (JavaModelException e1) {
            return false;
        }
        return input.equals(selectionAsInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean showInput(Object input) {
        Object element = null;
        if (input instanceof IFile && this.isOnClassPath((IFile)input)) {
            element = JavaCore.create((IFile)((IFile)input));
        }
        if (element == null) {
            element = input;
        }
        if (element != null) {
            StructuredSelection newSelection = new StructuredSelection(element);
            if (this.fViewer.getSelection().equals(newSelection)) {
                this.fViewer.reveal(element);
            } else {
                try {
                    this.fViewer.removeSelectionChangedListener(this.fSelectionListener);
                    this.fViewer.setSelection((ISelection)newSelection, true);
                    while (element != null && this.fViewer.getSelection().isEmpty()) {
                        if ((element = this.getParent(element)) == null) continue;
                        newSelection = new StructuredSelection(element);
                        this.fViewer.setSelection((ISelection)newSelection, true);
                    }
                }
                finally {
                    this.fViewer.addSelectionChangedListener(this.fSelectionListener);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isOnClassPath(IFile file) {
        IJavaProject jproject = JavaCore.create((IProject)file.getProject());
        return jproject.isOnClasspath((IResource)file);
    }

    private Object getParent(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getParent();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    void expandMainType(Object element) {
        try {
            IType type = null;
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)element;
                IType[] types = cu.getTypes();
                if (types.length > 0) {
                    type = types[0];
                }
            } else if (element instanceof IClassFile) {
                IClassFile cf = (IClassFile)element;
                type = cf.getType();
            }
            if (type != null) {
                final IType type2 = type;
                Control ctrl = this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            Control ctrl2 = PackageExplorerPart.this.fViewer.getControl();
                            if (ctrl2 != null && !ctrl2.isDisposed()) {
                                PackageExplorerPart.this.fViewer.expandToLevel(type2, 1);
                            }
                        }
                    });
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    Object getElementOfInput(IEditorInput input) {
        if (input instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)input).getClassFile();
        }
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        if (input instanceof JarEntryEditorInput) {
            return ((JarEntryEditorInput)input).getStorage();
        }
        return null;
    }

    TreeViewer getViewer() {
        return this.fViewer;
    }

    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    boolean isExpandable(Object element) {
        if (this.fViewer == null) {
            return false;
        }
        return this.fViewer.isExpandable(element);
    }

    void setWorkingSetName(String workingSetName) {
        this.fWorkingSetName = workingSetName;
    }

    void updateTitle() {
        Object input = this.fViewer.getInput();
        String viewName = this.getConfigurationElement().getAttribute("name");
        if (input == null || input instanceof IJavaModel) {
            this.setTitle(viewName);
            this.setTitleToolTip("");
        } else {
            String inputText = JavaElementLabels.getTextLabel(input, 1090519049);
            String title = PackagesMessages.getFormattedString("PackageExplorer.argTitle", new String[]{viewName, inputText});
            this.setTitle(title);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    public void setLabelDecorator(ILabelDecorator decorator) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fViewer == null) {
            return;
        }
        boolean refreshViewer = false;
        if ("org.eclipse.jdt.ui.packages.cuchildren".equals(event.getProperty())) {
            this.fActionSet.updateActionBars(this.getViewSite().getActionBars());
            boolean showCUChildren = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.packages.cuchildren");
            ((StandardJavaElementContentProvider)this.fViewer.getContentProvider()).setProvideMembers(showCUChildren);
            refreshViewer = true;
        } else if (MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            refreshViewer = true;
        }
        if (refreshViewer) {
            this.fViewer.refresh();
        }
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public PackageExplorerPart() {
        this.initLinkingEnabled();
        this.fSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PackageExplorerPart.this.handleSelectionChanged(event);
            }
        };
    }

    public boolean show(ShowInContext context) {
        Object input = context.getInput();
        if (input instanceof IEditorInput) {
            Object elementOfInput = this.getElementOfInput((IEditorInput)context.getInput());
            if (elementOfInput == null) {
                return false;
            }
            return this.tryToReveal(elementOfInput);
        }
        ISelection selection = context.getSelection();
        if (selection != null) {
            IStructuredSelection structuredSelection;
            if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
                return this.tryToReveal(structuredSelection.getFirstElement());
            }
            this.selectReveal(selection);
            return true;
        }
        return false;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(PackageExplorerPart.this.getViewer().getInput(), PackageExplorerPart.this.getViewer().getSelection());
            }
        };
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.fLinkingEnabled = enabled;
        PreferenceConstants.getPreferenceStore().setValue("org.eclipse.jdt.ui.packages.linktoeditor", enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(editor);
        }
    }

    String getFrameName(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getElementName();
        }
        return ((ILabelProvider)this.getTreeViewer().getLabelProvider()).getText(element);
    }

    void projectStateChanged(Object root) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            this.fViewer.refresh(root, true);
            this.fViewer.setSelection(this.fViewer.getSelection());
        }
    }

    public boolean tryToReveal(Object element) {
        CustomFiltersActionGroup filterGroup;
        String[] filters;
        if (this.revealElementOrParent(element)) {
            return true;
        }
        WorkingSetFilterActionGroup workingSetGroup = this.fActionSet.getWorkingSetActionGroup();
        IWorkingSet workingSet = workingSetGroup.getWorkingSet();
        if (workingSetGroup.isFiltered(this.getVisibleParent(element), element)) {
            String message = PackagesMessages.getFormattedString("PackageExplorer.notFound", workingSet.getName());
            if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)PackagesMessages.getString("PackageExplorer.filteredDialog.title"), (String)message)) {
                workingSetGroup.setWorkingSet(null, true);
                if (this.revealElementOrParent(element)) {
                    return true;
                }
            }
        }
        if ((filters = (filterGroup = this.fActionSet.getCustomFilterActionGroup()).removeFiltersFor(this.getVisibleParent(element), element, this.getTreeViewer().getContentProvider())).length > 0) {
            String message = PackagesMessages.getString("PackageExplorer.removeFilters");
            if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)PackagesMessages.getString("PackageExplorer.filteredDialog.title"), (String)message)) {
                filterGroup.setFilters(filters);
                if (this.revealElementOrParent(element)) {
                    return true;
                }
            }
        }
        FrameAction action = this.fActionSet.getUpAction();
        while (action.getFrameList().getCurrentIndex() > 0 && action.getFrameList().getSource().getFrame(3, 0) != null) {
            action.run();
            if (!this.revealElementOrParent(element)) continue;
            return true;
        }
        return false;
    }

    private boolean revealElementOrParent(Object element) {
        if (this.revealAndVerify(element)) {
            return true;
        }
        if ((element = this.getVisibleParent(element)) != null) {
            IResource resource;
            if (this.revealAndVerify(element)) {
                return true;
            }
            if (element instanceof IJavaElement && (resource = ((IJavaElement)element).getResource()) != null && this.revealAndVerify(resource)) {
                return true;
            }
        }
        return false;
    }

    private Object getVisibleParent(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof IJavaElement)) {
            return object;
        }
        IJavaElement element2 = (IJavaElement)object;
        switch (element2.getElementType()) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                element2 = (IJavaElement)element2.getOpenable();
                break;
            }
            case 1: {
                element2 = null;
            }
        }
        if (element2.getElementType() == 5) {
            element2 = JavaModelUtil.toOriginal((ICompilationUnit)element2);
        }
        return element2;
    }

    private boolean revealAndVerify(Object element) {
        if (element == null) {
            return false;
        }
        this.selectReveal((ISelection)new StructuredSelection(element));
        IElementComparer comparer = this.getTreeViewer().getComparer();
        Object selected = ((IStructuredSelection)this.getSite().getSelectionProvider().getSelection()).getFirstElement();
        return comparer != null ? comparer.equals(element, selected) : element.equals(selected);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PackageExplorerProblemTreeViewer
    extends ProblemTreeViewer {
        List fPendingGetChildren = Collections.synchronizedList(new ArrayList());

        public PackageExplorerProblemTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void add(Object parentElement, Object[] childElements) {
            if (this.fPendingGetChildren.contains(parentElement)) {
                return;
            }
            super.add(parentElement, childElements);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object[] getRawChildren(Object parent) {
            try {
                this.fPendingGetChildren.add(parent);
                Object[] objectArray = super.getRawChildren(parent);
                return objectArray;
            }
            finally {
                this.fPendingGetChildren.remove(parent);
            }
        }

        protected Object[] getFilteredChildren(Object parent) {
            ArrayList<Object> list = new ArrayList<Object>();
            ViewerFilter[] filters = PackageExplorerPart.this.fViewer.getFilters();
            Object[] children = ((ITreeContentProvider)PackageExplorerPart.this.fViewer.getContentProvider()).getChildren(parent);
            for (int i = 0; i < children.length; ++i) {
                Object object = children[i];
                if (!this.isEssential(object)) {
                    if ((object = this.filter(object, parent, filters)) == null) continue;
                    list.add(object);
                    continue;
                }
                list.add(object);
            }
            return list.toArray();
        }

        public boolean isExpandable(Object parent) {
            if (PackageExplorerPart.this.isFlatLayout()) {
                return super.isExpandable(parent);
            }
            ViewerFilter[] filters = PackageExplorerPart.this.fViewer.getFilters();
            Object[] children = ((ITreeContentProvider)PackageExplorerPart.this.fViewer.getContentProvider()).getChildren(parent);
            for (int i = 0; i < children.length; ++i) {
                Object object = children[i];
                if (this.isEssential(object)) {
                    return true;
                }
                if ((object = this.filter(object, parent, filters)) == null) continue;
                return true;
            }
            return false;
        }

        private Object filter(Object object, Object parent, ViewerFilter[] filters) {
            for (int i = 0; i < filters.length; ++i) {
                ViewerFilter filter = filters[i];
                if (filter.select((Viewer)PackageExplorerPart.this.fViewer, parent, object)) continue;
                return null;
            }
            return object;
        }

        protected Object[] filter(Object[] elements) {
            if (PackageExplorerPart.this.isFlatLayout()) {
                return super.filter(elements);
            }
            ViewerFilter[] filters = this.getFilters();
            if (filters == null || filters.length == 0) {
                return elements;
            }
            ArrayList<Object> filtered = new ArrayList<Object>(elements.length);
            Object root = this.getRoot();
            for (int i = 0; i < elements.length; ++i) {
                boolean add = true;
                if (!this.isEssential(elements[i])) {
                    for (int j = 0; j < filters.length && (add = filters[j].select((Viewer)this, root, elements[i])); ++j) {
                    }
                }
                if (!add) continue;
                filtered.add(elements[i]);
            }
            return filtered.toArray();
        }

        private boolean isEssential(Object object) {
            try {
                if (!PackageExplorerPart.this.isFlatLayout() && object instanceof IPackageFragment) {
                    IPackageFragment fragment = (IPackageFragment)object;
                    return !fragment.isDefaultPackage() && fragment.hasSubpackages();
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return false;
        }

        protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
            IStructuredSelection is = (IStructuredSelection)invalidSelection;
            ArrayList<Object> ns = null;
            ns = newSelection instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)newSelection).toList()) : new ArrayList<Object>();
            boolean changed = false;
            Iterator iter = is.iterator();
            while (iter.hasNext()) {
                IProject project;
                Object element = iter.next();
                if (element instanceof IJavaProject) {
                    project = ((IJavaProject)element).getProject();
                    if (project.isOpen()) continue;
                    ns.add(project);
                    changed = true;
                    continue;
                }
                if (!(element instanceof IProject) || !(project = (IProject)element).isOpen()) continue;
                IJavaProject jProject = JavaCore.create((IProject)project);
                if (jProject != null && jProject.exists()) {
                    ns.add(jProject);
                }
                changed = true;
            }
            if (changed) {
                newSelection = new StructuredSelection(ns);
                this.setSelection(newSelection);
            }
            super.handleInvalidSelection(invalidSelection, newSelection);
        }
    }
}

