/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import javax.management.MBeanNotificationInfo;
import javax.management.monitor.Monitor;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private String stringToCompare;
    private boolean notifyMatch;
    private boolean notifyDiffers;
    private String derivedGauge;
    private long derivedGaugeTimesamp;
    private transient String lastValue;
    private static final MBeanNotificationInfo[] notificationInfos = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.string.matches", "jmx.monitor.string.differs"}, "javax.management.monitor.MonitorNotification", "Notifications sent by the StringMonitor MBean")};

    public synchronized void start() {
        this.doStart();
    }

    public synchronized void stop() {
        this.doStop();
    }

    synchronized void executeMonitor(Object attributeValue) {
        if (this.lastValue != null && this.lastValue.equals(attributeValue)) {
            return;
        }
        if (this.stringToCompare == null) {
            this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" target value is null"));
            this.notifyListeners("jmx.notification.error.type", this.objectName, this.attribute);
        }
        if (!(attributeValue instanceof String)) {
            this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" attribute is not String"));
            this.notifyListeners("jmx.notification.error.type", this.objectName, this.attribute);
            return;
        }
        this.calculateDerivedGauge((String)attributeValue);
        boolean matches = attributeValue.equals(this.stringToCompare);
        this.lastValue = (String)attributeValue;
        if (this.notifyMatch && matches) {
            this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" found a match"));
            this.notifyListeners("jmx.monitor.string.matches", this.objectName, this.attribute);
        }
        if (this.notifyDiffers && !matches) {
            this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" found a difference"));
            this.notifyListeners("jmx.monitor.string.differs", this.objectName, this.attribute);
        }
    }

    void calculateDerivedGauge(String value) {
        this.derivedGauge = value;
        this.derivedGaugeTimesamp = System.currentTimeMillis();
    }

    public String getDerivedGauge() {
        return this.derivedGauge;
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimesamp;
    }

    public String getStringToCompare() {
        return this.stringToCompare;
    }

    public void setStringToCompare(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Cannot compare to null");
        }
        this.lastValue = null;
        this.stringToCompare = value;
    }

    public boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    public synchronized void setNotifyMatch(boolean value) {
        this.lastValue = null;
        this.notifyMatch = value;
    }

    public boolean getNotifyDiffer() {
        return this.notifyDiffers;
    }

    public synchronized void setNotifyDiffer(boolean value) {
        this.lastValue = null;
        this.notifyDiffers = value;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notificationInfos;
    }

    public String toString() {
        return "StringMonitor on " + super.toString();
    }
}

