/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.core.index.DiskIndex;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.MemoryIndex;
import org.eclipse.jdt.internal.core.search.indexing.InternalSearchDocument;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.util.SimpleSet;

public class Index {
    public String printableName;
    public ReadWriteMonitor monitor;
    protected DiskIndex diskIndex;
    protected MemoryIndex memoryIndex;

    public static String convertPath(String pathString) {
        int index = pathString.indexOf("|");
        if (index == -1) {
            return pathString;
        }
        Path jarPath = new Path(pathString.substring(0, index));
        return (jarPath.isAbsolute() ? jarPath.toOSString() : jarPath.makeAbsolute().toString()) + pathString.substring(index, pathString.length());
    }

    public static boolean isMatch(char[] pattern, char[] word, int matchRule) {
        if (pattern == null) {
            return true;
        }
        switch (matchRule) {
            case 0: {
                return CharOperation.equals(pattern, word, false);
            }
            case 1: {
                return CharOperation.prefixEquals(pattern, word, false);
            }
            case 2: {
                return CharOperation.match(pattern, word, false);
            }
            case 8: {
                return CharOperation.equals(pattern, word);
            }
            case 9: {
                return CharOperation.prefixEquals(pattern, word);
            }
            case 10: {
                return CharOperation.match(pattern, word, true);
            }
        }
        return false;
    }

    public Index(String fileName, String printableName, boolean reuseExistingFile) throws IOException {
        this.printableName = printableName;
        this.monitor = new ReadWriteMonitor();
        this.memoryIndex = new MemoryIndex();
        this.diskIndex = new DiskIndex(fileName);
        this.diskIndex.initialize(reuseExistingFile);
    }

    public void addIndexEntry(char[] category, char[] key, InternalSearchDocument document) {
        this.memoryIndex.addIndexEntry(category, key, document);
    }

    public File getIndexFile() {
        if (this.diskIndex == null) {
            return null;
        }
        return this.diskIndex.getIndexFile();
    }

    public boolean hasChanged() {
        return this.memoryIndex.hasChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryResult[] query(char[][] categories, char[] key, int matchRule) throws IOException {
        HashtableOfObject results;
        if (this.memoryIndex.shouldMerge() && this.monitor.exitReadEnterWrite()) {
            try {
                this.save();
            }
            finally {
                this.monitor.exitWriteEnterRead();
            }
        }
        if (this.memoryIndex.hasChanged()) {
            results = this.diskIndex.addQueryResults(categories, key, matchRule, this.memoryIndex);
            this.memoryIndex.addQueryResults(categories, key, matchRule, results);
        } else {
            results = this.diskIndex.addQueryResults(categories, key, matchRule, null);
        }
        if (results.elementSize == 0) {
            return null;
        }
        EntryResult[] entryResults = new EntryResult[results.elementSize];
        int count = 0;
        Object[] values = results.valueTable;
        int l = values.length;
        for (int i = 0; i < l; ++i) {
            EntryResult result = (EntryResult)values[i];
            if (result == null) continue;
            entryResults[count++] = result;
        }
        return entryResults;
    }

    public String[] queryDocumentNames(String substring) throws IOException {
        SimpleSet results;
        if (this.memoryIndex.hasChanged()) {
            results = this.diskIndex.addDocumentNames(substring, this.memoryIndex);
            this.memoryIndex.addDocumentNames(substring, results);
        } else {
            results = this.diskIndex.addDocumentNames(substring, null);
        }
        if (results.elementSize == 0) {
            return null;
        }
        String[] documentNames = new String[results.elementSize];
        int count = 0;
        Object[] paths = results.values;
        int l = paths.length;
        for (int i = 0; i < l; ++i) {
            if (paths[i] == null) continue;
            documentNames[count++] = (String)paths[i];
        }
        return documentNames;
    }

    public void remove(String documentName) {
        this.memoryIndex.remove(documentName);
    }

    public void save() throws IOException {
        if (!this.hasChanged()) {
            return;
        }
        int numberOfChanges = this.memoryIndex.docsToReferences.elementSize;
        this.diskIndex = this.diskIndex.mergeWith(this.memoryIndex);
        this.memoryIndex = new MemoryIndex();
        if (numberOfChanges > 1000) {
            System.gc();
        }
    }

    public void startQuery() throws IOException {
        if (this.diskIndex != null) {
            this.diskIndex.startQuery();
        }
    }

    public void stopQuery() throws IOException {
        if (this.diskIndex != null) {
            this.diskIndex.stopQuery();
        }
    }

    public String toString() {
        if (this.printableName != null) {
            return this.printableName;
        }
        return super.toString();
    }
}

