/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.backoff.BackOff;
import org.apache.camel.util.backoff.BackOffTimer;
import org.apache.camel.util.backoff.BackOffTimerTask;
import org.apache.camel.util.function.ThrowingFunction;

public class DefaultBackOffTimer
extends ServiceSupport
implements BackOffTimer {
    private final CamelContext camelContext;
    private final ScheduledExecutorService scheduler;
    private final String name;
    private final Set<BackOffTimer.Task> tasks = new CopyOnWriteArraySet<BackOffTimer.Task>();

    public DefaultBackOffTimer(CamelContext camelContext, String name, ScheduledExecutorService scheduler) {
        this.camelContext = camelContext;
        this.scheduler = scheduler;
        this.name = name;
    }

    public BackOffTimer.Task schedule(BackOff backOff, ThrowingFunction<BackOffTimer.Task, Boolean, Exception> function) {
        BackOffTimerTask task = new BackOffTimerTask((BackOffTimer)this, backOff, this.scheduler, function);
        long delay = task.next();
        if (delay != -1L) {
            this.tasks.add((BackOffTimer.Task)task);
            this.scheduler.schedule((Runnable)task, delay, TimeUnit.MILLISECONDS);
        } else {
            task.cancel();
        }
        return task;
    }

    public String getName() {
        return this.name;
    }

    public void remove(BackOffTimer.Task task) {
        this.tasks.remove(task);
    }

    public Set<BackOffTimer.Task> getTasks() {
        return Collections.unmodifiableSet(this.tasks);
    }

    public int size() {
        return this.tasks.size();
    }

    protected void doStart() throws Exception {
        this.camelContext.addService((Object)this);
    }

    protected void doStop() throws Exception {
        this.tasks.clear();
        this.camelContext.removeService((Object)this);
    }
}

