/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.InputStream;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.aries.jax.rs.rest.management.RestManagementConstants;
import org.apache.aries.jax.rs.rest.management.internal.BaseResource;
import org.apache.aries.jax.rs.rest.management.schema.BundleExceptionSchema;
import org.apache.aries.jax.rs.rest.management.schema.BundleListSchema;
import org.apache.aries.jax.rs.rest.management.schema.BundleSchema;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class FrameworkBundlesResource
extends BaseResource {
    public FrameworkBundlesResource(BundleContext bundleContext) {
        super(bundleContext);
    }

    @GET
    @Produces(value={"application/org.osgi.bundles+json", "application/org.osgi.bundles+xml"})
    @Path(value="framework/bundles{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="GET/bundles", summary="Retrieves a Bundle List Representation from the REST management service", responses={@ApiResponse(responseCode="200", description="The request has been served successfully", content={@Content(schema=@Schema(implementation=BundleListSchema.class))}), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")}, parameters={@Parameter(name="<capability_namespace>", in=ParameterIn.QUERY, description="A query parameter whose name is an osgi capability namespace and whose value is a filter expression that follows the Core Specifications Framework Filter Syntax; see OSGi Core, Chapter 3.2.7 Filter Syntax. Filters are matched against the attributes of capabilities in the respective namespaces. If multiple capabilities for a given namespace are present, then a filter succeeds when one of these capabilities matches. When multiple filter expressions across namespaces are given, these are combined with the and operator.", examples={@ExampleObject(summary="format: <capability_namespace>=<filter_string>", value="osgi.identity=(osgi.identity=foo)&osgi.package.wiring=(osgi.package.wiring=com.foo)")})})
    public Response bundles(@Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        Predicate<Bundle> predicate = FrameworkBundlesResource.fromNamespaceQuery(this.uriInfo);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK).entity((Object)BundleListSchema.build(Stream.of(this.bundleContext.getBundles()).filter(predicate).map(Bundle::getBundleId).map(String::valueOf).map(id -> this.uriInfo.getBaseUriBuilder().path("framework").path("bundle").path("{id}").build(new Object[]{id}).toASCIIString()).collect(Collectors.toList())));
        return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundlestate+json" : "application/org.osgi.bundlestate+xml").map(type -> builder.type(type)).orElse(builder).build();
    }

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/org.osgi.bundle+json", "application/org.osgi.bundle+xml"})
    @Path(value="framework/bundles{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="POST/bundles", summary="Installs a new bundle to the managed framework and thereby logically appends it to the bundles resource", requestBody=@RequestBody(description="One of the following contents is allowed; a location string with content-type type 'text/plain' OR a bundle jar with content-type 'application/vnd.osgi.bundle'", required=true, content={@Content(mediaType="text/plain", schema=@Schema(description="a location string", type="string")), @Content(mediaType="application/vnd.osgi.bundle", schema=@Schema(description="a bundle jar", type="string", format="binary"))}), responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=BundleSchema.class))}), @ApiResponse(responseCode="400", description="the REST management service received a BundleException when trying to install", content={@Content(mediaType="application/org.osgi.bundleexception+json", schema=@Schema(implementation=BundleExceptionSchema.class)), @Content(mediaType="application/org.osgi.bundleexception+xml", schema=@Schema(implementation=BundleExceptionSchema.class))}), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")}, parameters={@Parameter(name="Content-Location", in=ParameterIn.HEADER, description="When posting a bundle jar a location string can be specified using the 'Content-Location' header", required=false)})
    public Response bundles(String location, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext, @HeaderParam(value="Content-Type") MediaType contentType) {
        try {
            Instant now = Instant.now().minusMillis(2L);
            Bundle bundle = this.bundleContext.installBundle(location);
            if (!now.isBefore(Instant.ofEpochMilli(bundle.getLastModified()))) {
                throw new WebApplicationException(location, 409);
            }
            Response.ResponseBuilder builder = Response.ok((Object)((Object)this.bundleSchema(bundle)));
            return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundle+json" : "application/org.osgi.bundle+xml").map(type -> builder.type(type)).orElse(builder).build();
        }
        catch (BundleException exception) {
            return Response.status((int)400).type(contentType.equals((Object)RestManagementConstants.APPLICATION_BUNDLE_JSON_TYPE) ? RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_JSON_TYPE : RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_XML_TYPE).entity((Object)BundleExceptionSchema.build(exception.getType(), exception.getMessage())).build();
        }
    }

    @POST
    @Consumes(value={"application/vnd.osgi.bundle"})
    @Produces(value={"application/org.osgi.bundle+json", "application/org.osgi.bundle+xml"})
    @Path(value="framework/bundles{ext:(\\.json|\\.xml)*}")
    @Operation(hidden=true)
    public Response bundles(InputStream inputStream, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext, @HeaderParam(value="Content-Location") String location, @HeaderParam(value="Content-Type") MediaType contentType) {
        try {
            location = Optional.ofNullable(location).orElseGet(() -> "org.apache.aries.jax.rs.whiteboard:".concat(UUID.randomUUID().toString()));
            Instant now = Instant.now().minusMillis(2L);
            Bundle bundle = this.bundleContext.installBundle(location, inputStream);
            if (!now.isBefore(Instant.ofEpochMilli(bundle.getLastModified()))) {
                throw new WebApplicationException(location, 409);
            }
            Response.ResponseBuilder builder = Response.ok((Object)((Object)this.bundleSchema(bundle)));
            return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundle+json" : "application/org.osgi.bundle+xml").map(type -> builder.type(type)).orElse(builder).build();
        }
        catch (BundleException exception) {
            return Response.status((int)400).type(contentType.equals((Object)RestManagementConstants.APPLICATION_BUNDLE_JSON_TYPE) ? RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_JSON_TYPE : RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_XML_TYPE).entity((Object)BundleExceptionSchema.build(exception.getType(), exception.getMessage())).build();
        }
    }
}

