/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.rewrites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.aql.clause.DistinctClause;
import org.apache.asterix.lang.aql.clause.ForClause;
import org.apache.asterix.lang.aql.expression.FLWOGRExpression;
import org.apache.asterix.lang.aql.expression.UnionExpr;
import org.apache.asterix.lang.aql.rewrites.AqlFunctionBodyRewriterFactory;
import org.apache.asterix.lang.aql.rewrites.visitor.AqlFunctionCallResolverVisitor;
import org.apache.asterix.lang.aql.visitor.AQLInlineUdfsVisitor;
import org.apache.asterix.lang.aql.visitor.base.IAQLVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.parser.FunctionParser;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.visitor.GatherFunctionCallsVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.hyracks.algebricks.common.utils.Pair;

class AqlQueryRewriter
implements IQueryRewriter {
    private final IParserFactory parserFactory;
    private final FunctionParser functionParser;
    private IReturningStatement topStatement;
    private List<FunctionDecl> declaredFunctions;
    private LangRewritingContext context;
    private MetadataProvider metadataProvider;

    AqlQueryRewriter(IParserFactory parserFactory) {
        this.parserFactory = parserFactory;
        this.functionParser = new FunctionParser(parserFactory);
    }

    protected void setup(List<FunctionDecl> declaredFunctions, IReturningStatement topStatement, MetadataProvider metadataProvider, LangRewritingContext context) {
        this.topStatement = topStatement;
        this.context = context;
        this.declaredFunctions = declaredFunctions;
        this.metadataProvider = metadataProvider;
    }

    public void rewrite(List<FunctionDecl> declaredFunctions, IReturningStatement topStatement, MetadataProvider metadataProvider, LangRewritingContext context, boolean inlineUdfs, Collection<VarIdentifier> externalVars) throws CompilationException {
        this.setup(declaredFunctions, topStatement, metadataProvider, context);
        if (topStatement.isTopLevel()) {
            this.wrapInLets();
        }
        this.resolveFunctionCalls();
        this.inlineDeclaredUdfs();
        topStatement.setVarCounter(context.getVarCounter().get());
    }

    protected void wrapInLets() {
        if (this.topStatement == null) {
            return;
        }
        Expression body = this.topStatement.getBody();
        if (body.getKind() != Expression.Kind.FLWOGR_EXPRESSION) {
            VarIdentifier var = this.context.newVariable();
            VariableExpr v = new VariableExpr(var);
            LetClause c1 = new LetClause(v, body);
            ArrayList<Clause> clauseList = new ArrayList<Clause>(1);
            clauseList.add((Clause)c1);
            FLWOGRExpression newBody = new FLWOGRExpression(clauseList, (Expression)new VariableExpr(var));
            this.topStatement.setBody((Expression)newBody);
        }
    }

    protected void resolveFunctionCalls() throws CompilationException {
        if (this.topStatement == null) {
            return;
        }
        AqlFunctionCallResolverVisitor visitor = new AqlFunctionCallResolverVisitor(this.metadataProvider, this.declaredFunctions);
        this.topStatement.accept((ILangVisitor)visitor, null);
    }

    protected void inlineDeclaredUdfs() throws CompilationException {
        if (this.topStatement == null) {
            return;
        }
        ArrayList<FunctionSignature> funIds = new ArrayList<FunctionSignature>();
        for (FunctionDecl functionDecl : this.declaredFunctions) {
            funIds.add(functionDecl.getSignature());
        }
        ArrayList storedFunctionDecls = new ArrayList();
        for (Expression topLevelExpr : this.topStatement.getDirectlyEnclosedExpressions()) {
            storedFunctionDecls.addAll(FunctionUtil.retrieveUsedStoredFunctions((MetadataProvider)this.metadataProvider, (Expression)topLevelExpr, funIds, null, this::getFunctionCalls, (FunctionParser)this.functionParser, (DataverseName)this.metadataProvider.getDefaultDataverseName()));
            this.declaredFunctions.addAll(storedFunctionDecls);
        }
        if (!this.declaredFunctions.isEmpty()) {
            AQLInlineUdfsVisitor aQLInlineUdfsVisitor = new AQLInlineUdfsVisitor(this.context, new AqlFunctionBodyRewriterFactory(this.parserFactory), this.declaredFunctions, this.metadataProvider);
            while (((Boolean)this.topStatement.accept((ILangVisitor)aQLInlineUdfsVisitor, this.declaredFunctions)).booleanValue()) {
            }
        }
        this.declaredFunctions.removeAll(storedFunctionDecls);
    }

    public Set<CallExpr> getFunctionCalls(Expression expression) throws CompilationException {
        GatherFunctionCalls gfc = new GatherFunctionCalls();
        expression.accept((ILangVisitor)gfc, null);
        return gfc.getCalls();
    }

    public Set<VariableExpr> getExternalVariables(Expression expr) {
        throw new UnsupportedOperationException("getExternalVariables not implemented for AQL");
    }

    private static class GatherFunctionCalls
    extends GatherFunctionCallsVisitor
    implements IAQLVisitor<Void, Void> {
        @Override
        public Void visit(DistinctClause dc, Void arg) throws CompilationException {
            for (Expression e : dc.getDistinctByExpr()) {
                e.accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }

        @Override
        public Void visit(FLWOGRExpression flwor, Void arg) throws CompilationException {
            for (Clause c : flwor.getClauseList()) {
                c.accept((ILangVisitor)this, (Object)arg);
            }
            flwor.getReturnExpr().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(ForClause fc, Void arg) throws CompilationException {
            fc.getInExpr().accept((ILangVisitor)this, (Object)arg);
            if (fc.getPosVarExpr() != null) {
                fc.getPosVarExpr().accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }

        public Void visit(GroupbyClause gc, Void arg) throws CompilationException {
            for (List list : gc.getGbyPairList()) {
                for (GbyVariableExpressionPair p : list) {
                    p.getExpr().accept((ILangVisitor)this, (Object)arg);
                }
            }
            if (gc.hasDecorList()) {
                for (GbyVariableExpressionPair gbyVariableExpressionPair : gc.getDecorPairList()) {
                    gbyVariableExpressionPair.getExpr().accept((ILangVisitor)this, (Object)arg);
                }
            }
            if (gc.hasGroupFieldList()) {
                for (Pair pair : gc.getGroupFieldList()) {
                    ((Expression)pair.first).accept((ILangVisitor)this, (Object)arg);
                }
            }
            if (gc.hasWithMap()) {
                for (Map.Entry entry : gc.getWithVarMap().entrySet()) {
                    ((Expression)entry.getKey()).accept((ILangVisitor)this, (Object)arg);
                }
            }
            return null;
        }

        public Void visit(LetClause lc, Void arg) throws CompilationException {
            lc.getBindingExpr().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(UnionExpr u, Void arg) throws CompilationException {
            for (Expression e : u.getExprs()) {
                e.accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }
    }
}

