/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service.strategies;

import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.service.strategies.SelectionStrategy;
import com.couchbase.client.core.state.LifecycleState;

public class PartitionSelectionStrategy
implements SelectionStrategy {
    public static final PartitionSelectionStrategy INSTANCE = new PartitionSelectionStrategy();

    private PartitionSelectionStrategy() {
    }

    @Override
    public Endpoint select(CouchbaseRequest request, Endpoint[] endpoints) {
        if (endpoints.length == 0) {
            return null;
        }
        if (request instanceof BinaryRequest) {
            if (request instanceof GetBucketConfigRequest) {
                return PartitionSelectionStrategy.selectFirstConnected(endpoints);
            }
            return PartitionSelectionStrategy.selectByPartition(endpoints, ((BinaryRequest)request).partition());
        }
        throw new IllegalStateException("The PartitionSelectionStrategy does not understand: " + request);
    }

    private static Endpoint selectByPartition(Endpoint[] endpoints, short partition) {
        if (partition >= 0) {
            Endpoint endpoint;
            int numEndpoints = endpoints.length;
            Endpoint endpoint2 = endpoint = numEndpoints == 1 ? endpoints[0] : endpoints[partition % numEndpoints];
            if (endpoint != null && endpoint.isState(LifecycleState.CONNECTED)) {
                return endpoint;
            }
            return null;
        }
        return PartitionSelectionStrategy.selectFirstConnected(endpoints);
    }

    private static Endpoint selectFirstConnected(Endpoint[] endpoints) {
        for (Endpoint endpoint : endpoints) {
            if (!endpoint.isState(LifecycleState.CONNECTED)) continue;
            return endpoint;
        }
        return null;
    }
}

