/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.util.StorageUtil;
import org.apache.logging.log4j.Level;

public class ExternalProperties
extends AbstractProperties {
    public ExternalProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public int getWebInterfacePort() {
        return this.accessor.getInt(Option.WEB_PORT);
    }

    public int getQueryWebInterfacePort() {
        return this.accessor.getInt(Option.WEB_QUERYINTERFACE_PORT);
    }

    public int getAPIServerPort() {
        return this.accessor.getInt(Option.API_PORT);
    }

    public int getActiveServerPort() {
        return this.accessor.getInt(Option.ACTIVE_PORT);
    }

    public Level getLogLevel() {
        return this.accessor.getLoggingLevel(Option.LOG_LEVEL);
    }

    public int getMaxWaitClusterActive() {
        return this.accessor.getInt(Option.MAX_WAIT_ACTIVE_CLUSTER);
    }

    public String getNCJavaParams() {
        return this.accessor.getString(Option.NC_JAVA_OPTS);
    }

    public String getCCJavaParams() {
        return this.accessor.getString(Option.CC_JAVA_OPTS);
    }

    public int getNcApiPort() {
        return this.accessor.getInt(Option.NC_API_PORT);
    }

    public int getMaxWebRequestSize() {
        return this.accessor.getInt(Option.MAX_WEB_REQUEST_SIZE);
    }

    public int getRequestsArchiveSize() {
        return this.accessor.getInt(Option.REQUESTS_ARCHIVE_SIZE);
    }

    public int getLibraryDeployTimeout() {
        return this.accessor.getInt(Option.LIBRARY_DEPLOY_TIMEOUT);
    }

    public int getAzureRequestTimeout() {
        return this.accessor.getInt(Option.AZURE_REQUEST_TIMEOUT);
    }

    public static enum Option implements IOption
    {
        WEB_PORT(OptionTypes.NONNEGATIVE_INTEGER, 19001, "The listen port of the legacy query interface"),
        WEB_QUERYINTERFACE_PORT(OptionTypes.NONNEGATIVE_INTEGER, 19006, "The listen port of the query web interface"),
        API_PORT(OptionTypes.NONNEGATIVE_INTEGER, 19002, "The listen port of the API server"),
        ACTIVE_PORT(OptionTypes.NONNEGATIVE_INTEGER, 19003, "The listen port of the active server"),
        NC_API_PORT(OptionTypes.NONNEGATIVE_INTEGER, 19004, "The listen port of the node controller API server"),
        LOG_LEVEL(OptionTypes.LEVEL, Level.WARN, "The logging level for master and slave processes"),
        MAX_WAIT_ACTIVE_CLUSTER(OptionTypes.POSITIVE_INTEGER, 60, "The max pending time (in seconds) for cluster startup. After the threshold, if the cluster still is not up and running, it is considered unavailable"),
        CC_JAVA_OPTS(OptionTypes.STRING, "-Xmx1024m", "The JVM options passed to the cluster controller process by managix"),
        NC_JAVA_OPTS(OptionTypes.STRING, "-Xmx1024m", "The JVM options passed to the node controller process(es) by managix"),
        MAX_WEB_REQUEST_SIZE(OptionTypes.POSITIVE_INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)200, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE), "The maximum accepted web request size in bytes"),
        REQUESTS_ARCHIVE_SIZE(OptionTypes.NONNEGATIVE_INTEGER, 50, "The maximum number of archived requests to maintain"),
        LIBRARY_DEPLOY_TIMEOUT(OptionTypes.POSITIVE_INTEGER, 1800, "Timeout to upload a UDF in seconds"),
        AZURE_REQUEST_TIMEOUT(OptionTypes.POSITIVE_INTEGER, 120, "Timeout for Azure client requests in seconds");

        private final IOptionType type;
        private final Object defaultValue;
        private final String description;

        private Option(IOptionType type, Object defaultValue, String description) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public Section section() {
            switch (this) {
                case WEB_PORT: 
                case WEB_QUERYINTERFACE_PORT: 
                case API_PORT: 
                case ACTIVE_PORT: 
                case REQUESTS_ARCHIVE_SIZE: {
                    return Section.CC;
                }
                case NC_API_PORT: {
                    return Section.NC;
                }
                case LOG_LEVEL: 
                case MAX_WAIT_ACTIVE_CLUSTER: 
                case MAX_WEB_REQUEST_SIZE: 
                case LIBRARY_DEPLOY_TIMEOUT: 
                case AZURE_REQUEST_TIMEOUT: {
                    return Section.COMMON;
                }
                case CC_JAVA_OPTS: 
                case NC_JAVA_OPTS: {
                    return Section.VIRTUAL;
                }
            }
            throw new IllegalStateException("NYI: " + this);
        }

        public String description() {
            return this.description;
        }

        public IOptionType type() {
            return this.type;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }
    }
}

