/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.control.common.config.OptionTypes;

public class OptimizationConfUtil {
    private static final int MIN_FRAME_LIMIT_FOR_SORT = 3;
    private static final int MIN_FRAME_LIMIT_FOR_GROUP_BY = 4;
    private static final int MIN_FRAME_LIMIT_FOR_JOIN = 5;
    private static final int MIN_FRAME_LIMIT_FOR_WINDOW = 5;
    public static final int MIN_FRAME_LIMIT_FOR_TEXT_SEARCH = 5;

    private OptimizationConfUtil() {
    }

    public static PhysicalOptimizationConfig createPhysicalOptimizationConf(CompilerProperties compilerProperties, Map<String, Object> querySpecificConfig, SourceLocation sourceLoc) throws AlgebricksException {
        int frameSize = compilerProperties.getFrameSize();
        int sortFrameLimit = OptimizationConfUtil.getSortNumFrames(compilerProperties, querySpecificConfig, sourceLoc);
        int groupFrameLimit = OptimizationConfUtil.getFrameLimit(CompilerProperties.COMPILER_GROUPMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_GROUPMEMORY_KEY), compilerProperties.getGroupMemorySize(), frameSize, 4, sourceLoc);
        int joinFrameLimit = OptimizationConfUtil.getFrameLimit(CompilerProperties.COMPILER_JOINMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_JOINMEMORY_KEY), compilerProperties.getJoinMemorySize(), frameSize, 5, sourceLoc);
        int windowFrameLimit = OptimizationConfUtil.getFrameLimit(CompilerProperties.COMPILER_WINDOWMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_WINDOWMEMORY_KEY), compilerProperties.getWindowMemorySize(), frameSize, 5, sourceLoc);
        int textSearchFrameLimit = OptimizationConfUtil.getTextSearchNumFrames(compilerProperties, querySpecificConfig, sourceLoc);
        int sortNumSamples = OptimizationConfUtil.getSortSamples(compilerProperties, querySpecificConfig, sourceLoc);
        boolean fullParallelSort = OptimizationConfUtil.getBoolean(querySpecificConfig, CompilerProperties.COMPILER_SORT_PARALLEL_KEY, compilerProperties.getSortParallel());
        boolean indexOnly = OptimizationConfUtil.getBoolean(querySpecificConfig, CompilerProperties.COMPILER_INDEXONLY_KEY, compilerProperties.isIndexOnly());
        boolean sanityCheck = OptimizationConfUtil.getBoolean(querySpecificConfig, CompilerProperties.COMPILER_INTERNAL_SANITYCHECK_KEY, compilerProperties.isSanityCheck());
        boolean externalFieldPushdown = OptimizationConfUtil.getBoolean(querySpecificConfig, CompilerProperties.COMPILER_EXTERNAL_FIELD_PUSHDOWN_KEY, compilerProperties.isFieldAccessPushdown());
        boolean subplanMerge = OptimizationConfUtil.getBoolean(querySpecificConfig, CompilerProperties.COMPILER_SUBPLAN_MERGE_KEY, compilerProperties.getSubplanMerge());
        boolean subplanNestedPushdown = OptimizationConfUtil.getBoolean(querySpecificConfig, CompilerProperties.COMPILER_SUBPLAN_NESTEDPUSHDOWN_KEY, compilerProperties.getSubplanNestedPushdown());
        boolean minMemoryAllocation = OptimizationConfUtil.getBoolean(querySpecificConfig, CompilerProperties.COMPILER_MIN_MEMORY_ALLOCATION_KEY, compilerProperties.getMinMemoryAllocation());
        boolean arrayIndex = OptimizationConfUtil.getBoolean(querySpecificConfig, CompilerProperties.COMPILER_ARRAYINDEX_KEY, compilerProperties.isArrayIndex());
        int externalScanBufferSize = OptimizationConfUtil.getExternalScanBufferSize((String)querySpecificConfig.get(CompilerProperties.COMPILER_EXTERNALSCANMEMORY_KEY), compilerProperties.getExternalScanMemorySize(), sourceLoc);
        boolean cbo = OptimizationConfUtil.getBoolean(querySpecificConfig, CompilerProperties.COMPILER_CBO_KEY, compilerProperties.getCBOMode());
        boolean cboTest = OptimizationConfUtil.getBoolean(querySpecificConfig, CompilerProperties.COMPILER_CBO_TEST_KEY, compilerProperties.getCBOTestMode());
        boolean forceJoinOrder = OptimizationConfUtil.getBoolean(querySpecificConfig, CompilerProperties.COMPILER_FORCE_JOIN_ORDER_KEY, compilerProperties.getForceJoinOrderMode());
        String queryPlanShape = OptimizationConfUtil.getString(querySpecificConfig, CompilerProperties.COMPILER_QUERY_PLAN_SHAPE_KEY, compilerProperties.getQueryPlanShapeMode());
        PhysicalOptimizationConfig physOptConf = new PhysicalOptimizationConfig();
        physOptConf.setFrameSize(frameSize);
        physOptConf.setMaxFramesExternalSort(sortFrameLimit);
        physOptConf.setMaxFramesExternalGroupBy(groupFrameLimit);
        physOptConf.setMaxFramesForJoin(joinFrameLimit);
        physOptConf.setMaxFramesForWindow(windowFrameLimit);
        physOptConf.setMaxFramesForTextSearch(textSearchFrameLimit);
        physOptConf.setSortParallel(fullParallelSort);
        physOptConf.setSortSamples(sortNumSamples);
        physOptConf.setIndexOnly(indexOnly);
        physOptConf.setSanityCheckEnabled(sanityCheck);
        physOptConf.setExternalFieldPushdown(externalFieldPushdown);
        physOptConf.setSubplanMerge(subplanMerge);
        physOptConf.setSubplanNestedPushdown(subplanNestedPushdown);
        physOptConf.setMinMemoryAllocation(minMemoryAllocation);
        physOptConf.setArrayIndexEnabled(arrayIndex);
        physOptConf.setExternalScanBufferSize(externalScanBufferSize);
        physOptConf.setCBOMode(cbo);
        physOptConf.setCBOTestMode(cboTest);
        physOptConf.setForceJoinOrderMode(forceJoinOrder);
        physOptConf.setQueryPlanShapeMode(queryPlanShape);
        return physOptConf;
    }

    private static int getExternalScanBufferSize(String externalScanMemorySizeParameter, int compilerExternalScanMemorySize, SourceLocation sourceLoc) throws AsterixException {
        IOptionType intByteParser = OptionTypes.INTEGER_BYTE_UNIT;
        try {
            return externalScanMemorySizeParameter != null ? (Integer)intByteParser.parse(externalScanMemorySizeParameter) : compilerExternalScanMemorySize;
        }
        catch (IllegalArgumentException e) {
            throw AsterixException.create(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{e.getMessage()});
        }
    }

    public static int getSortNumFrames(CompilerProperties compilerProperties, Map<String, Object> querySpecificConfig, SourceLocation sourceLoc) throws AlgebricksException {
        return OptimizationConfUtil.getFrameLimit(CompilerProperties.COMPILER_SORTMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_SORTMEMORY_KEY), compilerProperties.getSortMemorySize(), compilerProperties.getFrameSize(), 3, sourceLoc);
    }

    public static int getGroupByNumFrames(CompilerProperties compilerProperties, Map<String, Object> querySpecificConfig, SourceLocation sourceLoc) throws AlgebricksException {
        return OptimizationConfUtil.getFrameLimit(CompilerProperties.COMPILER_GROUPMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_GROUPMEMORY_KEY), compilerProperties.getGroupMemorySize(), compilerProperties.getFrameSize(), 4, sourceLoc);
    }

    public static int getTextSearchNumFrames(CompilerProperties compilerProperties, Map<String, Object> querySpecificConfig, SourceLocation sourceLoc) throws AlgebricksException {
        return OptimizationConfUtil.getFrameLimit(CompilerProperties.COMPILER_TEXTSEARCHMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_TEXTSEARCHMEMORY_KEY), compilerProperties.getTextSearchMemorySize(), compilerProperties.getFrameSize(), 5, sourceLoc);
    }

    private static int getFrameLimit(String parameterName, String parameter, long memBudgetInConfiguration, int frameSize, int minFrameLimit, SourceLocation sourceLoc) throws AlgebricksException {
        long memBudget;
        IOptionType longBytePropertyInterpreter = OptionTypes.LONG_BYTE_UNIT;
        try {
            memBudget = parameter == null ? memBudgetInConfiguration : (Long)longBytePropertyInterpreter.parse(parameter);
        }
        catch (IllegalArgumentException e) {
            throw AsterixException.create(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{e.getMessage()});
        }
        int frameLimit = (int)(memBudget / (long)frameSize);
        if (frameLimit < minFrameLimit) {
            throw AsterixException.create(ErrorCode.COMPILATION_BAD_QUERY_PARAMETER_VALUE, sourceLoc, new Serializable[]{parameterName, Integer.valueOf(frameSize * minFrameLimit), "bytes"});
        }
        return Math.max(frameLimit, minFrameLimit);
    }

    private static int getSortSamples(CompilerProperties compilerProperties, Map<String, Object> querySpecificConfig, SourceLocation sourceLoc) throws AsterixException {
        String valueInQuery = (String)querySpecificConfig.get(CompilerProperties.COMPILER_SORT_SAMPLES_KEY);
        try {
            return valueInQuery == null ? compilerProperties.getSortSamples() : ((Integer)OptionTypes.POSITIVE_INTEGER.parse(valueInQuery)).intValue();
        }
        catch (IllegalArgumentException e) {
            throw AsterixException.create(ErrorCode.COMPILATION_BAD_QUERY_PARAMETER_VALUE, sourceLoc, new Serializable[]{CompilerProperties.COMPILER_SORT_SAMPLES_KEY, Integer.valueOf(1), "samples"});
        }
    }

    private static boolean getBoolean(Map<String, Object> queryConfig, String queryConfigKey, boolean defaultValue) {
        String valueInQuery = (String)queryConfig.get(queryConfigKey);
        if (valueInQuery != null) {
            return (Boolean)OptionTypes.BOOLEAN.parse(valueInQuery);
        }
        return defaultValue;
    }

    private static String getString(Map<String, Object> queryConfig, String queryConfigKey, String defaultValue) {
        String valueInQuery = (String)queryConfig.get(queryConfigKey);
        if (valueInQuery != null) {
            return valueInQuery;
        }
        return defaultValue;
    }
}

