/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import org.apache.felix.deploymentadmin.Utils;

class ContentCopyingJarInputStream
extends JarInputStream {
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private final File m_contentDir;
    private PrintWriter m_indexFileWriter;
    private OutputStream m_entryOS;

    public ContentCopyingJarInputStream(InputStream in, File indexFile, File contentDir) throws IOException {
        super(in, true);
        this.m_contentDir = contentDir;
        this.m_indexFileWriter = new PrintWriter(new FileWriter(indexFile));
        this.m_entryOS = null;
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            this.copyManifest(manifest);
        }
    }

    public void close() throws IOException {
        this.closeCopy();
        this.closeIndex();
    }

    public void closeEntry() throws IOException {
        this.closeCopy();
        super.closeEntry();
    }

    public ZipEntry getNextEntry() throws IOException {
        this.closeCopy();
        ZipEntry entry = super.getNextEntry();
        if (entry != null) {
            File current = new File(this.m_contentDir, entry.getName());
            if (!entry.isDirectory()) {
                this.addToIndex(entry.getName());
                this.m_entryOS = this.createOutputStream(current);
            }
        }
        return entry;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int r = super.read(b, off, len);
        if (this.m_entryOS != null) {
            if (r > 0) {
                this.m_entryOS.write(b, off, r);
            } else {
                this.closeCopy();
            }
        }
        return r;
    }

    private void addToIndex(String name) throws IOException {
        this.m_indexFileWriter.println(name);
        this.m_indexFileWriter.flush();
    }

    private void closeCopy() {
        Utils.closeSilently(this.m_entryOS);
        this.m_entryOS = null;
    }

    private void closeIndex() {
        Utils.closeSilently(this.m_indexFileWriter);
        this.m_indexFileWriter = null;
    }

    private void copyManifest(Manifest manifest) throws IOException {
        this.addToIndex(MANIFEST_FILE);
        OutputStream os = this.createOutputStream(new File(this.m_contentDir, MANIFEST_FILE));
        try {
            manifest.write(os);
        }
        finally {
            Utils.closeSilently(os);
        }
    }

    private OutputStream createOutputStream(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (!file.createNewFile()) {
            throw new IOException("Attempt to overwrite file: " + file);
        }
        return new GZIPOutputStream(new FileOutputStream(file));
    }
}

