/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.util.Preconditions;

public class StateUtils {
    @Nullable
    public static <T> T getSingleValueFromState(StateInitializationContext context, String stateName, Class<T> valueClass, T defaultValue) throws Exception {
        ListState state = context.getOperatorStateStore().getListState(new ListStateDescriptor(stateName, valueClass));
        ArrayList<T> values = new ArrayList<T>();
        ((Iterable)state.get()).forEach(values::add);
        if (context.isRestored()) {
            if (values.isEmpty()) {
                return null;
            }
            for (int i = 1; i < values.size(); ++i) {
                Preconditions.checkState((boolean)values.get(i).equals(values.get(i - 1)), (Object)"Values in list state are not the same. This is unexpected.");
            }
        } else {
            Preconditions.checkState((boolean)values.isEmpty(), (Object)("Expecting 0 value for a fresh state but found " + values.size() + ". This is unexpected."));
            state.add(defaultValue);
            values.add(defaultValue);
        }
        return (T)values.get(0);
    }
}

