/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.topology.Vertex;
import org.apache.flink.util.IterableUtils;

class SchedulingStrategyUtils {
    SchedulingStrategyUtils() {
    }

    static List<ExecutionVertexID> sortExecutionVerticesInTopologicalOrder(SchedulingTopology topology, Set<ExecutionVertexID> verticesToDeploy) {
        return IterableUtils.toStream(topology.getVertices()).map(Vertex::getId).filter(verticesToDeploy::contains).collect(Collectors.toList());
    }

    static List<SchedulingPipelinedRegion> sortPipelinedRegionsInTopologicalOrder(SchedulingTopology topology, Set<SchedulingPipelinedRegion> regions) {
        if (regions.size() == 0) {
            return Collections.emptyList();
        }
        if (regions.size() == 1) {
            return Collections.singletonList(regions.iterator().next());
        }
        return IterableUtils.toStream(topology.getVertices()).map(Vertex::getId).map(topology::getPipelinedRegionOfVertex).filter(regions::contains).distinct().collect(Collectors.toList());
    }
}

