/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader.ColumnReader;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader.ParquetDataColumnReader;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader.ParquetDataColumnReaderFactory;
import org.apache.flink.table.store.shaded.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.flink.table.store.shaded.org.apache.parquet.bytes.BytesInput;
import org.apache.flink.table.store.shaded.org.apache.parquet.bytes.BytesUtils;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.ValuesType;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.DataPage;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.DataPageV1;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.DataPageV2;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.DictionaryPage;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.PageReader;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.values.ValuesReader;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.ParquetDecodingException;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.Type;
import org.apache.flink.table.types.logical.LogicalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseVectorizedColumnReader
implements ColumnReader<WritableColumnVector> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseVectorizedColumnReader.class);
    protected boolean isUtcTimestamp;
    protected long valuesRead;
    protected long endOfPageValueCount;
    protected final ParquetDataColumnReader dictionary;
    protected boolean isCurrentPageDictionaryEncoded;
    protected final int maxDefLevel;
    protected int definitionLevel;
    protected int repetitionLevel;
    protected IntIterator repetitionLevelColumn;
    protected IntIterator definitionLevelColumn;
    protected ParquetDataColumnReader dataColumn;
    protected int pageValueCount;
    protected final PageReader pageReader;
    protected final ColumnDescriptor descriptor;
    protected final Type type;
    protected final LogicalType logicalType;

    public BaseVectorizedColumnReader(ColumnDescriptor descriptor, PageReader pageReader, boolean isUtcTimestamp, Type parquetType, LogicalType logicalType) throws IOException {
        this.descriptor = descriptor;
        this.type = parquetType;
        this.pageReader = pageReader;
        this.maxDefLevel = descriptor.getMaxDefinitionLevel();
        this.isUtcTimestamp = isUtcTimestamp;
        this.logicalType = logicalType;
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = ParquetDataColumnReaderFactory.getDataColumnReaderByTypeOnDictionary(parquetType.asPrimitiveType(), dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage), isUtcTimestamp);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e) {
                throw new IOException(String.format("Could not decode the dictionary for %s", descriptor), e);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
    }

    protected void readRepetitionAndDefinitionLevels() {
        this.repetitionLevel = this.repetitionLevelColumn.nextInt();
        this.definitionLevel = this.definitionLevelColumn.nextInt();
        ++this.valuesRead;
    }

    protected void readPage() {
        DataPage page = this.pageReader.readPage();
        if (page == null) {
            return;
        }
        page.accept(new DataPage.Visitor<Void>(){

            @Override
            public Void visit(DataPageV1 dataPageV1) {
                BaseVectorizedColumnReader.this.readPageV1(dataPageV1);
                return null;
            }

            @Override
            public Void visit(DataPageV2 dataPageV2) {
                BaseVectorizedColumnReader.this.readPageV2(dataPageV2);
                return null;
            }
        });
    }

    private void initDataReader(Encoding dataEncoding, ByteBufferInputStream in, int valueCount) throws IOException {
        this.pageValueCount = valueCount;
        this.endOfPageValueCount = this.valuesRead + (long)this.pageValueCount;
        if (dataEncoding.usesDictionary()) {
            this.dataColumn = null;
            if (this.dictionary == null) {
                throw new IOException(String.format("Could not read page in col %s because the dictionary was missing for encoding %s.", new Object[]{this.descriptor, dataEncoding}));
            }
            this.dataColumn = ParquetDataColumnReaderFactory.getDataColumnReaderByType(this.type.asPrimitiveType(), dataEncoding.getDictionaryBasedValuesReader(this.descriptor, ValuesType.VALUES, this.dictionary.getDictionary()), this.isUtcTimestamp);
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            this.dataColumn = ParquetDataColumnReaderFactory.getDataColumnReaderByType(this.type.asPrimitiveType(), dataEncoding.getValuesReader(this.descriptor, ValuesType.VALUES), this.isUtcTimestamp);
            this.isCurrentPageDictionaryEncoded = false;
        }
        try {
            this.dataColumn.initFromPage(this.pageValueCount, in);
        }
        catch (IOException e) {
            throw new IOException(String.format("Could not read page in col %s.", this.descriptor), e);
        }
    }

    private void readPageV1(DataPageV1 page) {
        ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.descriptor, ValuesType.REPETITION_LEVEL);
        ValuesReader dlReader = page.getDlEncoding().getValuesReader(this.descriptor, ValuesType.DEFINITION_LEVEL);
        this.repetitionLevelColumn = new ValuesReaderIntIterator(rlReader);
        this.definitionLevelColumn = new ValuesReaderIntIterator(dlReader);
        try {
            BytesInput bytes = page.getBytes();
            LOG.debug("Page size {}  bytes and {} records.", (Object)bytes.size(), (Object)this.pageValueCount);
            ByteBufferInputStream in = bytes.toInputStream();
            LOG.debug("Reading repetition levels at {}.", (Object)in.position());
            rlReader.initFromPage(this.pageValueCount, in);
            LOG.debug("Reading definition levels at {}.", (Object)in.position());
            dlReader.initFromPage(this.pageValueCount, in);
            LOG.debug("Reading data at {}.", (Object)in.position());
            this.initDataReader(page.getValueEncoding(), in, page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(String.format("Could not read page %s in col %s.", page, this.descriptor), e);
        }
    }

    private void readPageV2(DataPageV2 page) {
        this.pageValueCount = page.getValueCount();
        this.repetitionLevelColumn = this.newRLEIterator(this.descriptor.getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionLevelColumn = this.newRLEIterator(this.descriptor.getMaxDefinitionLevel(), page.getDefinitionLevels());
        try {
            LOG.debug("Page data size {} bytes and {} records.", (Object)page.getData().size(), (Object)this.pageValueCount);
            this.initDataReader(page.getDataEncoding(), page.getData().toInputStream(), page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(String.format("Could not read page %s in col %s.", page, this.descriptor), e);
        }
    }

    private IntIterator newRLEIterator(int maxLevel, BytesInput bytes) {
        try {
            if (maxLevel == 0) {
                return new NullIntIterator();
            }
            return new RLEIntIterator(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt(maxLevel), new ByteArrayInputStream(bytes.toByteArray())));
        }
        catch (IOException e) {
            throw new ParquetDecodingException(String.format("Could not read levels in page for col %s.", this.descriptor), e);
        }
    }

    protected static final class NullIntIterator
    implements IntIterator {
        protected NullIntIterator() {
        }

        @Override
        public int nextInt() {
            return 0;
        }
    }

    protected static final class RLEIntIterator
    implements IntIterator {
        RunLengthBitPackingHybridDecoder delegate;

        public RLEIntIterator(RunLengthBitPackingHybridDecoder delegate) {
            this.delegate = delegate;
        }

        @Override
        public int nextInt() {
            try {
                return this.delegate.readInt();
            }
            catch (IOException e) {
                throw new ParquetDecodingException(e);
            }
        }
    }

    protected static final class ValuesReaderIntIterator
    implements IntIterator {
        ValuesReader delegate;

        public ValuesReaderIntIterator(ValuesReader delegate) {
            this.delegate = delegate;
        }

        @Override
        public int nextInt() {
            return this.delegate.readInteger();
        }
    }

    static interface IntIterator {
        public int nextInt();
    }
}

