/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import io.micrometer.core.instrument.MeterRegistry;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.ToDataException;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.AllBucketProfilesUpdateMessage;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.OverflowAttributes;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientRegistrationEventQueueManager;
import org.apache.geode.internal.cache.tier.sockets.ClientRegistrationMetadata;
import org.apache.geode.internal.cache.tier.sockets.ConnectionListener;
import org.apache.geode.internal.cache.tier.sockets.ConnectionListenerAdapter;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.ServerConnectionFactory;
import org.apache.geode.internal.cache.wan.GatewayReceiverStats;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.logging.CoreLoggingExecutors;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.internal.statistics.StatisticsClockFactory;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.internal.util.ArrayUtils;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.executors.LoggingThreadFactory;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class AcceptorImpl
implements Acceptor,
Runnable {
    private static final Logger logger = LogService.getLogger();
    private static final boolean isJRockit = System.getProperty("java.vm.name").contains("JRockit");
    private static final int HANDSHAKER_DEFAULT_POOL_SIZE = 4;
    private static final int CLIENT_QUEUE_INITIALIZATION_POOL_SIZE = 16;
    private final CacheServerStats stats;
    private final int maxConnections;
    private final int maxThreads;
    private final ExecutorService pool;
    private final ExecutorService hsPool;
    private final ExecutorService clientQueueInitPool;
    private final int localPort;
    private ServerSocket serverSock;
    private final InternalCache cache;
    private final CachedRegionHelper crHelper;
    private final Object syncLock;
    private final Selector selector;
    private final LinkedBlockingQueue<ByteBuffer> commBufferQueue;
    private final SystemTimer hsTimer;
    private final LinkedBlockingQueue<ServerConnection> selectorQueue;
    private final Set<ServerConnection> selectorRegistrations;
    private final boolean tcpNoDelay;
    private static final String HANDSHAKE_TIMEOUT_PROPERTY_NAME = "BridgeServer.handShakeTimeout";
    private static final int DEFAULT_HANDSHAKE_TIMEOUT_MS = 59000;
    private static final int handshakeTimeout = Integer.getInteger("BridgeServer.handShakeTimeout", 59000);
    public static final String ACCEPT_TIMEOUT_PROPERTY_NAME = "BridgeServer.acceptTimeout";
    private static final int DEFAULT_ACCEPT_TIMEOUT_MS = 9900;
    private final int acceptTimeout;
    static final int MINIMUM_MAX_CONNECTIONS = 16;
    private final int socketBufferSize;
    private final CacheClientNotifier clientNotifier;
    private static final int DEFAULT_BACKLOG = 1280;
    private static final String BACKLOG_PROPERTY_NAME = "BridgeServer.backlog";
    private static final String CHECK_REGISTERED_KEYS_INTERVAL_NAME = "check-registered-keys-interval-ns";
    private static final int DEFAULT_CHECK_REGISTERED_KEYS_INTERVAL_NS = 0;
    private final long checkRegisteredKeysInterval;
    private final AtomicInteger clientServerCnxCount;
    private volatile boolean shutdownStarted;
    private Thread thread;
    private Thread selectorThread;
    private final Object allSCsLock;
    private final Set<ServerConnection> allSCs;
    private volatile ServerConnection[] allSCList;
    private final String bindHostName;
    private final ConnectionListener connectionListener;
    private final ClientHealthMonitor healthMonitor;
    private final boolean notifyBySubscription;
    private long acceptorId;
    @MakeNotStatic
    private static boolean isAuthenticationRequired;
    @MakeNotStatic
    private static boolean isPostAuthzCallbackPresent;
    private final boolean isGatewayReceiver;
    private final List<GatewayTransportFilter> gatewayTransportFilters;
    private final StatisticsClock statisticsClock;
    private final SocketCreator socketCreator;
    private final SecurityService securityService;
    private final ServerConnectionFactory serverConnectionFactory;
    @Deprecated
    private static final boolean DEPRECATED_SELECTOR;
    @Deprecated
    private final int DEPRECATED_SELECTOR_POOL_SIZE;
    private final int HANDSHAKE_POOL_SIZE;
    private static final boolean WORKAROUND_SELECTOR_BUG;
    private Selector tmpSel;
    private int registeredKeys;
    private boolean loggedAcceptError;

    AcceptorImpl(int port, String bindHostName, boolean notifyBySubscription, int socketBufferSize, int maximumTimeBetweenPings, InternalCache internalCache, int maxConnections, int maxThreads, int maximumMessageCount, int messageTimeToLive, ConnectionListener connectionListener, OverflowAttributes overflowAttributes, boolean tcpNoDelay, ServerConnectionFactory serverConnectionFactory, long timeLimitMillis, SecurityService securityService, Supplier<SocketCreator> socketCreatorSupplier, CacheClientNotifier.CacheClientNotifierProvider cacheClientNotifierProvider, ClientHealthMonitor.ClientHealthMonitorProvider clientHealthMonitorProvider) throws IOException {
        this(port, bindHostName, notifyBySubscription, socketBufferSize, maximumTimeBetweenPings, internalCache, maxConnections, maxThreads, maximumMessageCount, messageTimeToLive, connectionListener, overflowAttributes, tcpNoDelay, serverConnectionFactory, timeLimitMillis, securityService, socketCreatorSupplier, cacheClientNotifierProvider, clientHealthMonitorProvider, false, Collections.emptyList(), StatisticsClockFactory.disabledClock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AcceptorImpl(int port, String bindHostName, boolean notifyBySubscription, int socketBufferSize, int maximumTimeBetweenPings, InternalCache internalCache, int maxConnections, int maxThreads, int maximumMessageCount, int messageTimeToLive, ConnectionListener connectionListener, OverflowAttributes overflowAttributes, boolean tcpNoDelay, ServerConnectionFactory serverConnectionFactory, long timeLimitMillis, SecurityService securityService, Supplier<SocketCreator> socketCreatorSupplier, CacheClientNotifier.CacheClientNotifierProvider cacheClientNotifierProvider, ClientHealthMonitor.ClientHealthMonitorProvider clientHealthMonitorProvider, boolean isGatewayReceiver, List<GatewayTransportFilter> gatewayTransportFilters, StatisticsClock statisticsClock) throws IOException {
        DistributionManager dm;
        int backLog;
        block35: {
            this.syncLock = new Object();
            this.acceptTimeout = Integer.getInteger(ACCEPT_TIMEOUT_PROPERTY_NAME, 9900);
            this.checkRegisteredKeysInterval = Long.getLong(CHECK_REGISTERED_KEYS_INTERVAL_NAME, 0L);
            this.clientServerCnxCount = new AtomicInteger();
            this.allSCsLock = new Object();
            this.allSCs = new HashSet<ServerConnection>();
            this.allSCList = new ServerConnection[0];
            this.DEPRECATED_SELECTOR_POOL_SIZE = Integer.getInteger("BridgeServer.SELECTOR_POOL_SIZE", 16);
            this.HANDSHAKE_POOL_SIZE = Integer.getInteger("BridgeServer.HANDSHAKE_POOL_SIZE", 4);
            this.securityService = securityService;
            this.statisticsClock = statisticsClock;
            this.isGatewayReceiver = isGatewayReceiver;
            this.gatewayTransportFilters = gatewayTransportFilters;
            this.bindHostName = AcceptorImpl.calcBindHostName(internalCache, bindHostName);
            this.connectionListener = connectionListener == null ? new ConnectionListenerAdapter() : connectionListener;
            this.notifyBySubscription = notifyBySubscription;
            this.serverConnectionFactory = serverConnectionFactory;
            int tmp_maxConnections = maxConnections;
            if (tmp_maxConnections < 16) {
                tmp_maxConnections = 16;
            }
            this.maxConnections = tmp_maxConnections;
            int tmp_maxThreads = maxThreads;
            if (maxThreads == 0 && DEPRECATED_SELECTOR) {
                tmp_maxThreads = this.DEPRECATED_SELECTOR_POOL_SIZE;
            }
            if (tmp_maxThreads < 0) {
                tmp_maxThreads = 0;
            } else if (tmp_maxThreads > this.maxConnections) {
                tmp_maxThreads = this.maxConnections;
            }
            boolean isWindows = false;
            String os = System.getProperty("os.name");
            if (os != null && os.contains("Windows")) {
                isWindows = true;
            }
            if (tmp_maxThreads > 0 && isWindows) {
                if (this.getBindAddress() instanceof Inet6Address) {
                    logger.warn("Ignoring max-threads setting and using zero instead due to JRockit NIO bugs.  See GemFire bug #40198");
                    tmp_maxThreads = 0;
                }
                if (isJRockit) {
                    logger.warn("Ignoring max-threads setting and using zero instead due to Java bug 6230761: NIO does not work with IPv6 on Windows.  See GemFire bug #40472");
                    tmp_maxThreads = 0;
                }
            }
            this.maxThreads = tmp_maxThreads;
            Selector tmp_s = null;
            LinkedBlockingQueue tmp_q = null;
            LinkedBlockingQueue tmp_commQ = null;
            HashSet tmp_hs = null;
            SystemTimer tmp_timer = null;
            if (this.isSelector()) {
                tmp_s = Selector.open();
                tmp_q = new LinkedBlockingQueue();
                tmp_commQ = new LinkedBlockingQueue();
                tmp_hs = new HashSet(512);
                tmp_timer = new SystemTimer(internalCache.getDistributedSystem());
            }
            this.selector = tmp_s;
            this.selectorQueue = tmp_q;
            this.commBufferQueue = tmp_commQ;
            this.selectorRegistrations = tmp_hs;
            this.hsTimer = tmp_timer;
            this.tcpNoDelay = tcpNoDelay;
            this.socketCreator = socketCreatorSupplier.get();
            InternalCache gc = this.getCachedRegionHelper() != null ? this.getCachedRegionHelper().getCache() : null;
            backLog = Integer.getInteger(BACKLOG_PROPERTY_NAME, 1280);
            long tilt = System.currentTimeMillis() + timeLimitMillis;
            if (this.isSelector()) {
                if (this.socketCreator.useSSL()) {
                    throw new IllegalArgumentException("Selector thread pooling can not be used with client/server SSL. The selector can be disabled by setting max-threads=0.");
                }
                ServerSocketChannel channel = ServerSocketChannel.open();
                this.serverSock = channel.socket();
                this.serverSock.setReuseAddress(true);
                this.serverSock.setReceiveBufferSize(socketBufferSize);
                while (true) {
                    try {
                        this.serverSock.bind(new InetSocketAddress(this.getBindAddress(), port), backLog);
                        break block35;
                    }
                    catch (SocketException b) {
                        if (System.currentTimeMillis() > tilt) {
                            throw b;
                        }
                        boolean interrupted = Thread.interrupted();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                        finally {
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (gc == null) continue;
                        gc.getCancelCriterion().checkCancelInProgress(null);
                        continue;
                    }
                    break;
                }
            }
            while (true) {
                try {
                    this.serverSock = this.socketCreator.createServerSocket(port, backLog, this.getBindAddress(), this.gatewayTransportFilters, socketBufferSize);
                }
                catch (SocketException e) {
                    if (System.currentTimeMillis() > tilt) {
                        throw e;
                    }
                    boolean interrupted = Thread.interrupted();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {
                        interrupted = true;
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (gc == null) continue;
                    gc.getCancelCriterion().checkCancelInProgress(null);
                    continue;
                }
                break;
            }
        }
        this.localPort = port == 0 ? this.serverSock.getLocalPort() : port;
        InternalDistributedSystem ds = internalCache.getInternalDistributedSystem();
        if (ds != null && (dm = ds.getDistributionManager()) != null && dm.getDistributionManagerId().getMembershipPort() == 0 && dm instanceof LonerDistributionManager) {
            ((LonerDistributionManager)dm).updateLonerPort(this.localPort);
        }
        String sockName = this.getServerName();
        logger.info("Cache server connection listener bound to address {} with backlog {}.", (Object)sockName, (Object)backLog);
        StatisticsManager statisticsFactory = internalCache.getInternalDistributedSystem().getStatisticsManager();
        if (this.isGatewayReceiver()) {
            MeterRegistry meterRegistry = internalCache.getMeterRegistry();
            this.stats = GatewayReceiverStats.createGatewayReceiverStats(statisticsFactory, sockName, meterRegistry);
        } else {
            this.stats = new CacheServerStats(statisticsFactory, sockName);
        }
        this.cache = internalCache;
        this.crHelper = new CachedRegionHelper(this.cache);
        this.clientNotifier = cacheClientNotifierProvider.get(internalCache, new ClientRegistrationEventQueueManager(), statisticsClock, this.stats, maximumMessageCount, messageTimeToLive, this.connectionListener, overflowAttributes, this.isGatewayReceiver());
        this.socketBufferSize = socketBufferSize;
        this.healthMonitor = clientHealthMonitorProvider.get(internalCache, maximumTimeBetweenPings, this.clientNotifier.getStats());
        this.pool = this.initializeServerConnectionThreadPool();
        this.hsPool = this.initializeHandshakerThreadPool();
        this.clientQueueInitPool = this.initializeClientQueueInitializerThreadPool();
        isAuthenticationRequired = securityService.isClientSecurityRequired();
        String postAuthzFactoryName = this.cache.getDistributedSystem().getProperties().getProperty("security-client-accessor-pp");
        isPostAuthzCallbackPresent = postAuthzFactoryName != null && !postAuthzFactoryName.isEmpty();
    }

    private ExecutorService initializeHandshakerThreadPool() throws IOException {
        String threadName = "Handshaker " + this.serverSock.getInetAddress() + ":" + this.localPort + " Thread ";
        try {
            logger.warn("Handshaker max Pool size: " + this.HANDSHAKE_POOL_SIZE);
            return CoreLoggingExecutors.newThreadPoolWithSynchronousFeedThatHandlesRejection(threadName, thread -> this.getStats().incAcceptThreadsCreated(), null, 1, this.HANDSHAKE_POOL_SIZE, 60L);
        }
        catch (IllegalArgumentException poolInitException) {
            this.stats.close();
            this.serverSock.close();
            this.pool.shutdown();
            throw poolInitException;
        }
    }

    private ExecutorService initializeClientQueueInitializerThreadPool() {
        return CoreLoggingExecutors.newThreadPoolWithSynchronousFeed("Client Queue Initialization Thread ", command -> {
            try {
                command.run();
            }
            catch (CancelException e) {
                logger.debug("Client Queue Initialization was canceled.", (Throwable)e);
            }
        }, 16, this.getStats().getCnxPoolHelper(), 60000, this.getThreadMonitorObj());
    }

    private ExecutorService initializeServerConnectionThreadPool() throws IOException {
        LoggingThreadFactory.ThreadInitializer threadInitializer = thread -> this.getStats().incConnectionThreadsCreated();
        LoggingThreadFactory.CommandWrapper commandWrapper = command -> {
            try {
                command.run();
            }
            catch (CancelException cancelException) {
            }
            finally {
                ConnectionTable.releaseThreadsSockets();
            }
        };
        try {
            String threadName = "ServerConnection on port " + this.localPort + " Thread ";
            if (this.isSelector()) {
                return CoreLoggingExecutors.newThreadPoolWithUnlimitedFeed(threadName, threadInitializer, commandWrapper, this.maxThreads, this.getStats().getCnxPoolHelper(), Integer.MAX_VALUE, this.getThreadMonitorObj());
            }
            return CoreLoggingExecutors.newThreadPoolWithSynchronousFeed(threadName, threadInitializer, commandWrapper, 16, this.maxConnections, 0L);
        }
        catch (IllegalArgumentException poolInitException) {
            this.stats.close();
            this.serverSock.close();
            throw poolInitException;
        }
    }

    private ThreadsMonitoring getThreadMonitorObj() {
        DistributionManager distributionManager = this.cache.getDistributionManager();
        if (distributionManager != null) {
            return distributionManager.getThreadMonitoring();
        }
        return null;
    }

    @Override
    public long getAcceptorId() {
        return this.acceptorId;
    }

    @Override
    public CacheServerStats getStats() {
        return this.stats;
    }

    @Override
    public boolean isSelector() {
        return this.maxThreads > 0;
    }

    @Override
    public void start() {
        this.thread = new LoggingThread("Cache Server Acceptor " + this.serverSock.getInetAddress() + ":" + this.localPort + " local port: " + this.serverSock.getLocalPort(), false, (Runnable)this);
        this.acceptorId = this.thread.getId();
        this.thread.start();
        if (this.isSelector()) {
            this.selectorThread = new LoggingThread("Cache Server Selector " + this.serverSock.getInetAddress() + ":" + this.localPort + " local port: " + this.serverSock.getLocalPort(), false, this::runSelectorLoop);
            this.selectorThread.start();
        }
        Set<PartitionedRegion> prs = this.cache.getPartitionedRegions();
        for (PartitionedRegion pr : prs) {
            HashMap<Integer, BucketAdvisor.BucketProfile> profiles = new HashMap<Integer, BucketAdvisor.BucketProfile>();
            Map<Integer, BucketAdvisor> advisors = pr.getRegionAdvisor().getAllBucketAdvisors();
            for (Map.Entry<Integer, BucketAdvisor> entry : advisors.entrySet()) {
                BucketAdvisor advisor = entry.getValue();
                BucketAdvisor.BucketProfile bp = (BucketAdvisor.BucketProfile)advisor.createProfile();
                advisor.updateServerBucketProfile(bp);
                profiles.put(entry.getKey(), bp);
            }
            Set<InternalDistributedMember> recipients = pr.getRegionAdvisor().adviseAllPRNodes();
            ReplyProcessor21 reply = AllBucketProfilesUpdateMessage.send(recipients, pr.getDistributionManager(), pr.getPRId(), profiles);
            if (reply == null) continue;
            reply.waitForRepliesUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServerConnection(ServerConnection serverConnection) {
        Object object = this.syncLock;
        synchronized (object) {
            if (!this.isRunning()) {
                this.finishCon(serverConnection);
                return;
            }
        }
        this.getSelectorQueue().offer(serverConnection);
        this.wakeupSelector();
    }

    private void wakeupSelector() {
        Selector s = this.getSelector();
        if (s != null && s.isOpen()) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterServerConnection(ServerConnection serverConnection) {
        Object object = this.allSCsLock;
        synchronized (object) {
            this.allSCs.remove(serverConnection);
            Iterator<ServerConnection> it = this.allSCs.iterator();
            ServerConnection[] again = new ServerConnection[this.allSCs.size()];
            for (int i = 0; i < again.length; ++i) {
                again[i] = it.next();
            }
            this.allSCList = again;
        }
        if (!this.isRunning()) {
            return;
        }
        this.wakeupSelector();
    }

    private void finishCon(ServerConnection sc) {
        if (sc != null) {
            sc.handleTermination();
        }
    }

    private void drainSelectorQueue() {
        ServerConnection sc = this.selectorQueue.poll();
        CancelException cce = null;
        while (sc != null) {
            block7: {
                try {
                    this.finishCon(sc);
                }
                catch (CancelException e) {
                    if (cce != null) break block7;
                    cce = e;
                }
            }
            sc = this.selectorQueue.poll();
        }
        for (ServerConnection selectorRegistration : this.selectorRegistrations) {
            try {
                this.finishCon(selectorRegistration);
            }
            catch (CancelException e) {
                if (cce != null) continue;
                cce = e;
            }
        }
        if (cce != null) {
            throw cce;
        }
    }

    @Override
    public void emergencyClose() {
        ServerConnection[] snap;
        ServerSocket ss = this.serverSock;
        if (ss != null) {
            try {
                ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.crHelper.setShutdown(true);
        for (ServerConnection serverConnection : snap = this.allSCList) {
            serverConnection.emergencyClose();
        }
    }

    private boolean isRegisteredObjectClosed(ServerConnection sc) {
        return sc.isClosed();
    }

    private int checkRegisteredKeys(int count) {
        int result = count;
        CancelException cce = null;
        if (count > 0) {
            Iterator<ServerConnection> it = this.selectorRegistrations.iterator();
            while (it.hasNext()) {
                ServerConnection sc = it.next();
                if (!this.isRegisteredObjectClosed(sc)) continue;
                --result;
                it.remove();
                try {
                    this.finishCon(sc);
                }
                catch (CancelException e) {
                    if (cce != null) continue;
                    cce = e;
                }
            }
        }
        if (cce != null) {
            throw cce;
        }
        return result;
    }

    private void checkForStuckKeys() {
        if (!WORKAROUND_SELECTOR_BUG) {
            return;
        }
        if (this.tmpSel == null) {
            try {
                this.tmpSel = Selector.open();
            }
            catch (IOException ignore) {
                logger.warn("Could not check for stuck keys.", (Throwable)ignore);
                return;
            }
        }
        for (SelectionKey sk : new ArrayList<SelectionKey>(this.selector.keys())) {
            ServerConnection sc = (ServerConnection)sk.attachment();
            if (sc == null) continue;
            try {
                sk.cancel();
                this.selector.selectNow();
                SelectionKey tmpsk = sc.getSelectableChannel().register(this.tmpSel, 5);
                try {
                    int events = this.tmpSel.selectNow();
                    if (events == 0) {
                        logger.info("stuck selection key detected on {}", (Object)sc);
                        tmpsk.cancel();
                        this.tmpSel.selectNow();
                        sc.registerWithSelector2(this.selector);
                        continue;
                    }
                    if (tmpsk.isValid() && tmpsk.isReadable()) {
                        try {
                            tmpsk.cancel();
                            this.tmpSel.selectNow();
                            this.selectorRegistrations.remove(sc);
                            --this.registeredKeys;
                            sc.makeBlocking();
                            sc.setProcessingMessage();
                        }
                        catch (ClosedChannelException ignore) {
                            this.finishCon(sc);
                            continue;
                        }
                        catch (IOException ex) {
                            this.finishCon(sc);
                            if (!this.isRunning()) continue;
                            logger.warn("Unexpected Exception:", (Throwable)ex);
                            continue;
                        }
                        try {
                            this.stats.incThreadQueueSize();
                            this.pool.execute(sc);
                        }
                        catch (RejectedExecutionException rejected) {
                            this.finishCon(sc);
                            this.stats.decThreadQueueSize();
                            if (!this.isRunning()) break;
                            logger.warn("Unexpected Exception:", (Throwable)rejected);
                        }
                        continue;
                    }
                    if (tmpsk.isValid() && tmpsk.isWritable()) {
                        tmpsk.cancel();
                        this.tmpSel.selectNow();
                        sc.registerWithSelector2(this.selector);
                        continue;
                    }
                    if (tmpsk.isValid()) continue;
                    tmpsk.cancel();
                    this.tmpSel.selectNow();
                    sc.registerWithSelector2(this.selector);
                }
                catch (IOException ex) {
                    if (!this.isRunning() || !this.selector.isOpen() || !this.tmpSel.isOpen()) continue;
                    logger.warn("Unexpected Exception:", (Throwable)ex);
                    try {
                        tmpsk.cancel();
                        this.tmpSel.selectNow();
                    }
                    catch (IOException ex2) {
                        if (!this.isRunning() || !this.selector.isOpen() || !this.tmpSel.isOpen()) continue;
                        logger.warn("Unexpected Exception:", (Throwable)ex2);
                    }
                }
            }
            catch (ClosedChannelException ignore) {
                this.finishCon(sc);
            }
            catch (IOException | NullPointerException ex) {
                if (!this.isRunning() || !this.selector.isOpen() || !this.tmpSel.isOpen()) continue;
                logger.warn("Unexpected Exception:", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSelectorLoop() {
        try {
            long lastCheckedTime = System.nanoTime();
            logger.info("SELECTOR enabled");
            block30: while (this.selector.isOpen() && !Thread.currentThread().isInterrupted()) {
                SystemFailure.checkFailure();
                if (this.cache.isClosed()) {
                    break;
                }
                if (this.cache.getCancelCriterion().isCancelInProgress()) {
                    break;
                }
                long delta = System.nanoTime() - lastCheckedTime;
                if (this.checkRegisteredKeysInterval == 0L || delta >= this.checkRegisteredKeysInterval) {
                    this.registeredKeys = this.checkRegisteredKeys(this.registeredKeys);
                    lastCheckedTime = System.nanoTime();
                }
                ServerConnection sc = this.registeredKeys == 0 ? this.selectorQueue.take() : this.selectorQueue.poll();
                while (sc != null) {
                    try {
                        sc.registerWithSelector2(this.selector);
                        ++this.registeredKeys;
                        this.selectorRegistrations.add(sc);
                    }
                    catch (ClosedChannelException cce) {
                        this.finishCon(sc);
                    }
                    catch (RuntimeException ex) {
                        this.finishCon(sc);
                        logger.warn("ignoring", (Throwable)ex);
                    }
                    sc = this.selectorQueue.poll();
                }
                if (this.registeredKeys == 0) continue;
                int events = this.selector.select();
                if (this.cache.getCancelCriterion().isCancelInProgress()) {
                    break;
                }
                if (events == 0) {
                    this.checkForStuckKeys();
                }
                while (events > 0) {
                    Set<SelectionKey> sk = this.selector.selectedKeys();
                    if (sk == null) {
                        events = 0;
                        continue block30;
                    }
                    Iterator<SelectionKey> keysIterator = sk.iterator();
                    int cancelCount = 0;
                    while (keysIterator.hasNext()) {
                        SelectionKey key = keysIterator.next();
                        keysIterator.remove();
                        ServerConnection sc2 = (ServerConnection)key.attachment();
                        try {
                            if (key.isValid() && key.isReadable()) {
                                try {
                                    key.cancel();
                                    this.selectorRegistrations.remove(sc2);
                                    --this.registeredKeys;
                                    ++cancelCount;
                                    sc2.makeBlocking();
                                    sc2.setProcessingMessage();
                                }
                                catch (ClosedChannelException ignore) {
                                    this.finishCon(sc2);
                                    continue;
                                }
                                catch (IOException ex) {
                                    this.finishCon(sc2);
                                    if (!this.isRunning()) continue;
                                    logger.warn("unexpected", (Throwable)ex);
                                    continue;
                                }
                                try {
                                    this.stats.incThreadQueueSize();
                                    this.pool.execute(sc2);
                                }
                                catch (RejectedExecutionException rejected) {
                                    this.finishCon(sc2);
                                    this.stats.decThreadQueueSize();
                                    if (!this.isRunning()) break;
                                    logger.warn("unexpected", (Throwable)rejected);
                                }
                                continue;
                            }
                            this.finishCon(sc2);
                            if (!key.isValid()) continue;
                            logger.warn("ignoring event on selector key {}", (Object)key);
                        }
                        catch (CancelledKeyException ex) {
                            this.finishCon(sc2);
                        }
                    }
                    if (cancelCount > 0 && this.selector.isOpen()) {
                        events = this.selector.selectNow();
                        continue;
                    }
                    events = 0;
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ClosedSelectorException ex) {
            try {
                this.drainSelectorQueue();
            }
            finally {
                this.close();
            }
        }
        catch (IOException ex) {
            logger.warn("unexpected", (Throwable)ex);
        }
        finally {
            try {
                this.drainSelectorQueue();
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public int getPort() {
        return this.localPort;
    }

    @Override
    public String getServerName() {
        String name = this.serverSock.getLocalSocketAddress().toString();
        try {
            name = LocalHostUtil.getLocalHost().getCanonicalHostName() + "-" + name;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    @Override
    public InetAddress getServerInetAddress() {
        return this.serverSock.getInetAddress();
    }

    @Override
    public void run() {
        try {
            this.accept();
        }
        catch (CancelException cancelException) {
        }
        finally {
            try {
                if (this.serverSock != null) {
                    this.serverSock.close();
                }
            }
            catch (IOException iOException) {}
            if (this.stats != null) {
                this.stats.close();
            }
        }
    }

    private Selector getSelector() {
        return this.selector;
    }

    private BlockingQueue<ServerConnection> getSelectorQueue() {
        return this.selectorQueue;
    }

    private static void closeSocket(Socket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept() {
        while (this.isRunning()) {
            if (SystemFailure.getFailure() != null) {
                ServerSocket s = this.serverSock;
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                SystemFailure.checkFailure();
            }
            this.crHelper.checkCancelInProgress(null);
            Socket socket = null;
            try {
                socket = this.serverSock.accept();
                this.crHelper.checkCancelInProgress(null);
                socket.setKeepAlive(SocketCreator.ENABLE_TCP_KEEP_ALIVE);
                Object object = this.syncLock;
                synchronized (object) {
                    if (!this.isRunning()) {
                        AcceptorImpl.closeSocket(socket);
                        break;
                    }
                }
                this.loggedAcceptError = false;
                this.handOffNewClientConnection(socket, this.serverConnectionFactory);
            }
            catch (InterruptedIOException e) {
                AcceptorImpl.closeSocket(socket);
                if (!this.isRunning() || !logger.isDebugEnabled()) continue;
                logger.debug("Aborted due to interrupt: {}", (Throwable)e);
            }
            catch (IOException e) {
                AcceptorImpl.closeSocket(socket);
                if (!this.isRunning() || this.loggedAcceptError) continue;
                this.loggedAcceptError = true;
                logger.error("Cache server: Unexpected IOException from accept", (Throwable)e);
            }
            catch (CancelException e) {
                AcceptorImpl.closeSocket(socket);
                throw e;
            }
            catch (Exception e) {
                AcceptorImpl.closeSocket(socket);
                if (!this.isRunning()) continue;
                logger.fatal("Cache server: Unexpected Exception", (Throwable)e);
            }
        }
    }

    private void handOffNewClientConnection(Socket socket, ServerConnectionFactory serverConnectionFactory) {
        block2: {
            try {
                this.stats.incAcceptsInProgress();
                this.hsPool.execute(() -> {
                    boolean finished = false;
                    try {
                        this.handleNewClientConnection(socket, serverConnectionFactory);
                        finished = true;
                    }
                    catch (RegionDestroyedException rde) {
                        if (!rde.getMessage().contains("HARegion")) {
                            throw rde;
                        }
                    }
                    catch (CancelException rde) {
                    }
                    catch (AsynchronousCloseException rde) {
                    }
                    catch (IOException | ToDataException ex) {
                        if (this.isRunning() && !this.loggedAcceptError) {
                            this.loggedAcceptError = true;
                            if (ex instanceof SocketTimeoutException) {
                                logger.warn("Cache server: failed accepting client connection due to socket timeout.");
                            } else {
                                logger.warn("Cache server: failed accepting client connection " + ex, (Throwable)ex);
                            }
                        }
                    }
                    finally {
                        if (!finished) {
                            AcceptorImpl.closeSocket(socket);
                        }
                        if (this.isRunning()) {
                            this.stats.decAcceptsInProgress();
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejected) {
                AcceptorImpl.closeSocket(socket);
                if (!this.isRunning()) break block2;
                this.stats.decAcceptsInProgress();
                logger.warn("unexpected", (Throwable)rejected);
            }
        }
    }

    private ByteBuffer takeCommBuffer() {
        ByteBuffer result = this.commBufferQueue.poll();
        if (result == null) {
            result = ByteBuffer.allocateDirect(this.socketBufferSize);
        }
        return result;
    }

    private void releaseCommBuffer(ByteBuffer bb) {
        if (bb == null) {
            return;
        }
        if (this.isRunning()) {
            this.commBufferQueue.offer(bb);
        }
    }

    private void incClientServerCnxCount() {
        this.clientServerCnxCount.incrementAndGet();
    }

    @Override
    public void decClientServerConnectionCount() {
        this.clientServerCnxCount.decrementAndGet();
    }

    @Override
    public int getClientServerConnectionCount() {
        return this.clientServerCnxCount.get();
    }

    private boolean isNotifyBySubscription() {
        return this.notifyBySubscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewClientConnection(Socket socket, ServerConnectionFactory serverConnectionFactory) throws IOException {
        int curCnt;
        boolean notForQueue;
        CommunicationMode communicationMode;
        try {
            communicationMode = this.isSelector() ? this.getCommunicationModeForSelector(socket) : this.getCommunicationModeForNonSelector(socket);
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error processing client connection", (Throwable)e);
            throw new EOFException();
        }
        if (this.handOffQueueInitialization(socket, communicationMode)) {
            return;
        }
        logger.debug("cache server: Initializing {} communication socket: {}", (Object)communicationMode, (Object)socket);
        boolean bl = notForQueue = communicationMode != CommunicationMode.ClientToServerForQueue;
        if (notForQueue && (curCnt = this.getClientServerConnectionCount()) >= this.maxConnections) {
            logger.warn("Rejected connection from {} because current connection count of {} is greater than or equal to the configured max of {}", new Object[]{socket.getInetAddress(), curCnt, this.maxConnections});
            if (communicationMode.expectsConnectionRefusalMessage()) {
                try {
                    this.refuseHandshake(socket.getOutputStream(), String.format("exceeded max-connections %s", this.maxConnections), (byte)60);
                }
                catch (Exception ex) {
                    logger.debug("rejection message failed", (Throwable)ex);
                }
            }
            AcceptorImpl.closeSocket(socket);
            return;
        }
        ServerConnection serverConn = serverConnectionFactory.makeServerConnection(socket, this.cache, this.crHelper, this.stats, handshakeTimeout, this.socketBufferSize, communicationMode.toString(), communicationMode.getModeNumber(), this, this.securityService);
        Object ex = this.allSCsLock;
        synchronized (ex) {
            this.allSCs.add(serverConn);
            Object[] snap = this.allSCList;
            this.allSCList = (ServerConnection[])ArrayUtils.insert(snap, snap.length, serverConn);
        }
        if (notForQueue) {
            this.incClientServerCnxCount();
        }
        if (this.isSelector()) {
            serverConn.registerWithSelector();
        } else {
            try {
                this.pool.execute(serverConn);
            }
            catch (RejectedExecutionException rejected) {
                if (!this.isRunning()) {
                    return;
                }
                logger.warn("Rejected connection from {} because incoming request was rejected by pool possibly due to thread exhaustion", (Object)serverConn);
                try {
                    this.refuseHandshake(socket.getOutputStream(), String.format("exceeded max-connections %s", this.maxConnections), (byte)60);
                }
                catch (Exception ex2) {
                    logger.debug("rejection message failed", (Throwable)ex2);
                }
                serverConn.cleanup();
            }
        }
    }

    @Override
    public void refuseHandshake(OutputStream out, String message, byte exception) throws IOException {
        HeapDataOutputStream hdos = new HeapDataOutputStream(32, Version.CURRENT);
        DataOutputStream dos = new DataOutputStream((OutputStream)((Object)hdos));
        dos.writeByte(exception);
        dos.writeByte(0);
        dos.writeInt(0);
        InternalDistributedMember member = InternalDistributedSystem.getAnyInstance().getDistributedMember();
        HeapDataOutputStream memberDos = new HeapDataOutputStream(Version.CURRENT);
        DataSerializer.writeObject(member, memberDos);
        DataSerializer.writeByteArray(memberDos.toByteArray(), dos);
        memberDos.close();
        if (message == null) {
            message = "";
        }
        dos.writeUTF(message);
        dos.writeBoolean(Boolean.TRUE);
        out.write(hdos.toByteArray());
        out.flush();
    }

    private boolean handOffQueueInitialization(Socket socket, CommunicationMode communicationMode) {
        if (communicationMode.isSubscriptionFeed()) {
            boolean isPrimaryServerToClient = communicationMode == CommunicationMode.PrimaryServerToClient;
            this.clientQueueInitPool.execute(new ClientQueueInitializerTask(socket, isPrimaryServerToClient, this));
            return true;
        }
        return false;
    }

    private CommunicationMode getCommunicationModeForNonSelector(Socket socket) throws IOException {
        socket.setSoTimeout(0);
        this.socketCreator.handshakeIfSocketIsSSL(socket, this.acceptTimeout);
        byte communicationModeByte = (byte)socket.getInputStream().read();
        if (communicationModeByte == -1) {
            throw new EOFException();
        }
        return CommunicationMode.fromModeNumber(communicationModeByte);
    }

    private CommunicationMode getCommunicationModeForSelector(final Socket socket) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
        SocketChannel socketChannel = socket.getChannel();
        socketChannel.configureBlocking(false);
        int res = socketChannel.read(byteBuffer);
        socketChannel.configureBlocking(true);
        if (res < 0) {
            throw new EOFException();
        }
        if (res == 0) {
            SystemTimer.SystemTimerTask timerTask = new SystemTimer.SystemTimerTask(){

                @Override
                public void run2() {
                    logger.warn("Cache server: timed out waiting for handshake from {}", (Object)socket.getRemoteSocketAddress());
                    AcceptorImpl.closeSocket(socket);
                }
            };
            this.hsTimer.schedule(timerTask, this.acceptTimeout);
            res = socketChannel.read(byteBuffer);
            if (!timerTask.cancel() || res <= 0) {
                throw new EOFException();
            }
        }
        return CommunicationMode.fromModeNumber(byteBuffer.get(0));
    }

    @Override
    public boolean isRunning() {
        return !this.shutdownStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Object object = this.syncLock;
            synchronized (object) {
                if (!this.isRunning()) {
                    return;
                }
                this.shutdownStarted = true;
                logger.info("Cache server on port {} is shutting down.", (Object)this.localPort);
                if (this.thread != null) {
                    this.thread.interrupt();
                }
                try {
                    this.serverSock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.crHelper.setShutdown(true);
                this.shutdownSelectorIfIsSelector();
                ClientHealthMonitor.shutdownInstance();
                this.shutdownSCs();
                this.clientNotifier.shutdown(this.acceptorId);
                this.shutdownPools();
                this.stats.close();
                if (!this.cache.isClosed()) {
                    this.notifyCacheMembersOfClose();
                }
            }
        }
        catch (RuntimeException e) {
            logger.warn("unexpected", (Throwable)e);
        }
    }

    @Override
    public void notifyCacheMembersOfClose() {
        if (logger.isDebugEnabled()) {
            logger.debug("sending messages to all peers for removing this server..");
        }
        for (PartitionedRegion pr : this.cache.getPartitionedRegions()) {
            HashMap<Integer, BucketAdvisor.BucketProfile> profiles = new HashMap<Integer, BucketAdvisor.BucketProfile>();
            Map<Integer, BucketAdvisor> advisors = pr.getRegionAdvisor().getAllBucketAdvisors();
            for (Map.Entry<Integer, BucketAdvisor> entry : advisors.entrySet()) {
                BucketAdvisor advisor = entry.getValue();
                BucketAdvisor.BucketProfile bp = (BucketAdvisor.BucketProfile)advisor.createProfile();
                advisor.updateServerBucketProfile(bp);
                profiles.put(entry.getKey(), bp);
            }
            Set<InternalDistributedMember> recipients = pr.getRegionAdvisor().adviseAllPRNodes();
            ReplyProcessor21 reply = AllBucketProfilesUpdateMessage.send(recipients, pr.getDistributionManager(), pr.getPRId(), profiles);
            if (reply == null) continue;
            reply.waitForRepliesUninterruptibly();
        }
    }

    private void shutdownSelectorIfIsSelector() {
        if (this.isSelector()) {
            this.hsTimer.cancel();
            if (this.tmpSel != null) {
                try {
                    this.tmpSel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.wakeupSelector();
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.selectorThread != null) {
                this.selectorThread.interrupt();
            }
            this.commBufferQueue.clear();
        }
    }

    private void shutdownPools() {
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(PoolImpl.SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS)) {
                logger.warn("Timeout waiting for background tasks to complete.");
                this.pool.shutdownNow();
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            this.pool.shutdownNow();
        }
        this.clientQueueInitPool.shutdown();
        this.hsPool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownSCs() {
        Object object = this.allSCsLock;
        synchronized (object) {
            ServerConnection[] snap;
            for (ServerConnection serverConnection : snap = this.allSCList) {
                serverConnection.cleanup();
            }
        }
    }

    boolean isShutdownProperly() {
        return !(this.isRunning() || this.thread.isAlive() || this.selectorThread != null && this.selectorThread.isAlive() || this.pool != null && !this.pool.isShutdown() || this.hsPool != null && !this.hsPool.isShutdown() || this.clientQueueInitPool != null && !this.clientQueueInitPool.isShutdown() || this.selector != null && this.selector.isOpen() || this.tmpSel != null && this.tmpSel.isOpen());
    }

    private static String calcBindHostName(InternalCache cache, String bindName) {
        if (bindName != null && !bindName.isEmpty()) {
            return bindName;
        }
        InternalDistributedSystem system = cache.getInternalDistributedSystem();
        DistributionConfig config = system.getConfig();
        String hostName = null;
        String serverBindAddress = config.getServerBindAddress();
        if (serverBindAddress != null && !serverBindAddress.isEmpty()) {
            hostName = serverBindAddress;
        } else {
            String bindAddress = config.getBindAddress();
            if (bindAddress != null && !bindAddress.isEmpty()) {
                hostName = bindAddress;
            }
        }
        return hostName;
    }

    private InetAddress getBindAddress() throws IOException {
        if (this.bindHostName == null || this.bindHostName.isEmpty()) {
            return null;
        }
        return InetAddress.getByName(this.bindHostName);
    }

    @Override
    public String getExternalAddress() {
        String result = this.bindHostName;
        boolean needCanonicalHostName = false;
        if (result == null || result.isEmpty()) {
            needCanonicalHostName = true;
        } else {
            InetSocketAddress isa;
            InetAddress ssAddr;
            ServerSocket ss = this.serverSock;
            if (ss != null && ss.getLocalSocketAddress() instanceof InetSocketAddress && (ssAddr = (isa = (InetSocketAddress)ss.getLocalSocketAddress()).getAddress()) != null && ssAddr.isAnyLocalAddress()) {
                needCanonicalHostName = true;
            }
        }
        if (needCanonicalHostName) {
            try {
                result = LocalHostUtil.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException ex) {
                throw new IllegalStateException("getLocalHost failed with " + ex);
            }
        }
        return result;
    }

    @Override
    public CacheClientNotifier getCacheClientNotifier() {
        return this.clientNotifier;
    }

    @Override
    public CachedRegionHelper getCachedRegionHelper() {
        return this.crHelper;
    }

    @Override
    public ClientHealthMonitor getClientHealthMonitor() {
        return this.healthMonitor;
    }

    @Override
    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    @Override
    public boolean isGatewayReceiver() {
        return this.isGatewayReceiver;
    }

    public List<GatewayTransportFilter> getGatewayTransportFilters() {
        return this.gatewayTransportFilters;
    }

    static boolean isAuthenticationRequired() {
        return isAuthenticationRequired;
    }

    static boolean isPostAuthzCallbackPresent() {
        return isPostAuthzCallbackPresent;
    }

    @Override
    public Set<ServerConnection> getAllServerConnections() {
        return Collections.unmodifiableSet(this.allSCs);
    }

    @Override
    public ServerConnection[] getAllServerConnectionList() {
        return this.allSCList;
    }

    @Override
    public void setTLCommBuffer() {
        if (!this.isSelector()) {
            return;
        }
        Message.setTLCommBuffer(this.takeCommBuffer());
    }

    @Override
    public void releaseTLCommBuffer() {
        if (!this.isSelector()) {
            return;
        }
        this.releaseCommBuffer(Message.setTLCommBuffer(null));
    }

    static {
        DEPRECATED_SELECTOR = Boolean.getBoolean("BridgeServer.SELECTOR");
        WORKAROUND_SELECTOR_BUG = Boolean.getBoolean("CacheServer.NIO_SELECTOR_WORKAROUND");
    }

    private static class ClientQueueInitializerTask
    implements Runnable {
        private final Socket socket;
        private final boolean isPrimaryServerToClient;
        private final AcceptorImpl acceptor;

        ClientQueueInitializerTask(Socket socket, boolean isPrimaryServerToClient, AcceptorImpl acceptor) {
            this.socket = socket;
            this.acceptor = acceptor;
            this.isPrimaryServerToClient = isPrimaryServerToClient;
        }

        @Override
        public void run() {
            block4: {
                logger.info(":Cache server: Initializing {} server-to-client communication socket: {}", (Object)(this.isPrimaryServerToClient ? "primary" : "secondary"), (Object)this.socket);
                try {
                    ClientRegistrationMetadata clientRegistrationMetadata = new ClientRegistrationMetadata(this.acceptor.cache, this.socket);
                    if (clientRegistrationMetadata.initialize()) {
                        this.acceptor.getCacheClientNotifier().registerClient(clientRegistrationMetadata, this.socket, this.isPrimaryServerToClient, this.acceptor.getAcceptorId(), this.acceptor.isNotifyBySubscription());
                    }
                }
                catch (IOException ex) {
                    AcceptorImpl.closeSocket(this.socket);
                    if (!this.acceptor.isRunning() || this.acceptor.loggedAcceptError) break block4;
                    this.acceptor.loggedAcceptError = true;
                    if (ex instanceof SocketTimeoutException) {
                        logger.warn("Cache server: failed accepting client connection due to socket timeout.");
                    }
                    logger.warn("Cache server: failed accepting client connection " + ex, (Throwable)ex);
                }
            }
        }
    }
}

