/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.io.Serializable;
import java.net.InetAddress;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.configuration.AddressResolver;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionRequestor;

public class TcpCommunicationConfiguration
implements Serializable {
    private static final long serialVersionUID = 5471893193030200809L;
    public static final long DFLT_SELECTOR_SPINS = 0L;
    @SystemProperty(value="Defines how many non-blocking selector.selectNow() should be made before falling into selector.select(long) in NIO server. Can be set to Long.MAX_VALUE so selector threads will never block", type=Long.class, defaults="0")
    public static final String IGNITE_SELECTOR_SPINS = "IGNITE_SELECTOR_SPINS";
    private AddressResolver addrRslvr;
    private String locAddr;
    private int locPort = 47100;
    private int locPortRange = 100;
    private int shmemPort = -1;
    private boolean directBuf = true;
    private boolean directSndBuf;
    private long idleConnTimeout = 600000L;
    private long connTimeout = 5000L;
    private long maxConnTimeout = 600000L;
    private int reconCnt = 10;
    private int sockSndBuf = 32768;
    private int sockRcvBuf = 32768;
    private int msgQueueLimit = 0;
    private boolean usePairedConnections;
    private int connectionsPerNode = 1;
    private boolean tcpNoDelay = true;
    private boolean filterReachableAddrs = false;
    private int ackSndThreshold = 32;
    private int unackedMsgsBufSize;
    private long sockWriteTimeout = 2000L;
    private int boundTcpPort = -1;
    private int boundTcpShmemPort = -1;
    private int selectorsCnt = TcpCommunicationSpi.DFLT_SELECTORS_CNT;
    private volatile InetAddress locHost;
    private int slowClientQueueLimit;
    private boolean failureDetectionTimeoutEnabled = true;
    private long failureDetectionTimeout;
    private long selectorSpins = IgniteSystemProperties.getLong("IGNITE_SELECTOR_SPINS", 0L);
    private boolean forceClientToSrvConnections;
    private ConnectionRequestor connectionRequestor;

    public AddressResolver addrRslvr() {
        return this.addrRslvr;
    }

    public void addrRslvr(AddressResolver rslvr) {
        this.addrRslvr = rslvr;
    }

    public String localAddress() {
        return this.locAddr;
    }

    public void localAddress(String locAddr) {
        this.locAddr = locAddr;
    }

    public int localPort() {
        return this.locPort;
    }

    public void localPort(int locPort) {
        this.locPort = locPort;
    }

    public int localPortRange() {
        return this.locPortRange;
    }

    public void localPortRange(int locPortRange) {
        this.locPortRange = locPortRange;
    }

    public int shmemPort() {
        return this.shmemPort;
    }

    public void shmemPort(int shmemPort) {
        this.shmemPort = shmemPort;
    }

    public boolean directBuffer() {
        return this.directBuf;
    }

    public void directBuffer(boolean directBuf) {
        this.directBuf = directBuf;
    }

    public boolean directSendBuffer() {
        return this.directSndBuf;
    }

    public void directSendBuffer(boolean directSndBuf) {
        this.directSndBuf = directSndBuf;
    }

    public long idleConnectionTimeout() {
        return this.idleConnTimeout;
    }

    public void idleConnectionTimeout(long idleConnTimeout) {
        this.idleConnTimeout = idleConnTimeout;
    }

    public long connectionTimeout() {
        return this.connTimeout;
    }

    public void connectionTimeout(long connTimeout) {
        this.connTimeout = connTimeout;
    }

    public long maxConnectionTimeout() {
        return this.maxConnTimeout;
    }

    public void maxConnectionTimeout(long maxConnTimeout) {
        this.maxConnTimeout = maxConnTimeout;
    }

    public int reconCount() {
        return this.reconCnt;
    }

    public void reconCount(int reconCnt) {
        this.reconCnt = reconCnt;
    }

    public int socketSendBuffer() {
        return this.sockSndBuf;
    }

    public void socketSendBuffer(int sockSndBuf) {
        this.sockSndBuf = sockSndBuf;
    }

    public int socketReceiveBuffer() {
        return this.sockRcvBuf;
    }

    public void socketReceiveBuffer(int sockRcvBuf) {
        this.sockRcvBuf = sockRcvBuf;
    }

    public int messageQueueLimit() {
        return this.msgQueueLimit;
    }

    public void messageQueueLimit(int msgQueueLimit) {
        this.msgQueueLimit = msgQueueLimit;
    }

    public boolean usePairedConnections() {
        return this.usePairedConnections;
    }

    public void usePairedConnections(boolean usePairedConnections) {
        this.usePairedConnections = usePairedConnections;
    }

    public int connectionsPerNode() {
        return this.connectionsPerNode;
    }

    public void connectionsPerNode(int connectionsPerNode) {
        this.connectionsPerNode = connectionsPerNode;
    }

    public boolean tcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean filterReachableAddresses() {
        return this.filterReachableAddrs;
    }

    public void filterReachableAddresses(boolean filterReachableAddrs) {
        this.filterReachableAddrs = filterReachableAddrs;
    }

    public int ackSendThreshold() {
        return this.ackSndThreshold;
    }

    public void ackSendThreshold(int ackSndThreshold) {
        this.ackSndThreshold = ackSndThreshold;
    }

    public int unackedMsgsBufferSize() {
        return this.unackedMsgsBufSize;
    }

    public void unackedMsgsBufferSize(int unackedMsgsBufSize) {
        this.unackedMsgsBufSize = unackedMsgsBufSize;
    }

    public long socketWriteTimeout() {
        return this.sockWriteTimeout;
    }

    public void socketWriteTimeout(long sockWriteTimeout) {
        this.sockWriteTimeout = sockWriteTimeout;
    }

    public int boundTcpPort() {
        return this.boundTcpPort;
    }

    public void boundTcpPort(int boundTcpPort) {
        this.boundTcpPort = boundTcpPort;
    }

    public int boundTcpShmemPort() {
        return this.boundTcpShmemPort;
    }

    public void boundTcpShmemPort(int boundTcpShmemPort) {
        this.boundTcpShmemPort = boundTcpShmemPort;
    }

    public int selectorsCount() {
        return this.selectorsCnt;
    }

    public void selectorsCount(int selectorsCnt) {
        this.selectorsCnt = selectorsCnt;
    }

    public InetAddress localHost() {
        return this.locHost;
    }

    public void localHost(InetAddress locHost) {
        this.locHost = locHost;
    }

    public long selectorSpins() {
        return this.selectorSpins;
    }

    public void selectorSpins(long selectorSpins) {
        this.selectorSpins = selectorSpins;
    }

    public int slowClientQueueLimit() {
        return this.slowClientQueueLimit;
    }

    public void slowClientQueueLimit(int slowClientQueueLimit) {
        this.slowClientQueueLimit = slowClientQueueLimit;
    }

    public boolean failureDetectionTimeoutEnabled() {
        return this.failureDetectionTimeoutEnabled;
    }

    public void failureDetectionTimeoutEnabled(boolean failureDetectionTimeoutEnabled) {
        this.failureDetectionTimeoutEnabled = failureDetectionTimeoutEnabled;
    }

    public long failureDetectionTimeout() {
        return this.failureDetectionTimeout;
    }

    public void failureDetectionTimeout(long failureDetectionTimeout) {
        if (this.failureDetectionTimeoutEnabled) {
            this.failureDetectionTimeout = failureDetectionTimeout;
        }
    }

    public boolean forceClientToSrvConnections() {
        return this.forceClientToSrvConnections;
    }

    public void forceClientToSrvConnections(boolean forceClientToSrvConnections) {
        this.forceClientToSrvConnections = forceClientToSrvConnections;
    }

    public void connectionRequestor(ConnectionRequestor requestor) {
        this.connectionRequestor = requestor;
    }

    public ConnectionRequestor connectionRequestor() {
        return this.connectionRequestor;
    }
}

