"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const chai_1 = require("chai");
const ExtDomQuery_1 = require("../../../impl/util/ExtDomQuery");
const StandardInits_1 = require("../../frameworkBase/_ext/shared/StandardInits");
var defaultMyFaces = StandardInits_1.StandardInits.defaultMyFaces;
const sinon_1 = __importDefault(require("sinon"));
let oldProjectStage = null;
/**
 * Tests for our extended DomQuery functionality
 */
(0, mocha_1.describe)('ExtDomQuery test suite', () => {
    beforeEach(() => __awaiter(void 0, void 0, void 0, function* () {
        sinon_1.default.reset();
        //we test ES2019 with it and whether we have missed
        //a map somewhere
        return yield defaultMyFaces().then(() => {
            oldProjectStage = faces.getProjectStage;
            faces.getProjectStage = () => "Development";
        });
    }));
    (0, mocha_1.afterEach)(() => {
        faces.getProjectStage = oldProjectStage;
    });
    (0, mocha_1.it)('ExtDomQuery.By id must log a console error with ProjectStage == Development and non existing id', (done) => {
        const spy = sinon_1.default.spy(window.console, "error");
        try {
            ExtDomQuery_1.ExtDomQuery.byId("no_existent_element");
            (0, chai_1.expect)(spy.calledOnce).to.be.true;
        }
        finally {
            spy.restore();
        }
        done();
    });
    (0, mocha_1.it)('ExtDomQuery.By id must not log a console error with ProjectStage == Production and non existing id', (done) => {
        faces.getProjectStage = () => "Production";
        const spy = sinon_1.default.spy(window.console, "error");
        try {
            ExtDomQuery_1.ExtDomQuery.byId("no_existent_element");
            (0, chai_1.expect)(spy.notCalled).to.be.true;
        }
        finally {
            spy.restore();
        }
        done();
    });
});
//# sourceMappingURL=ExtDomQueryTest.spec.js.map