/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Path;
import javax.validation.Payload;
import javax.validation.ValidationException;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.bval.jsr303.ConstraintAnnotationAttributes;
import org.apache.bval.jsr303.ConstraintDescriptorImpl;
import org.apache.bval.jsr303.ConstraintValidationListener;
import org.apache.bval.jsr303.ConstraintValidatorContextImpl;
import org.apache.bval.jsr303.GroupValidationContext;
import org.apache.bval.jsr303.util.NodeImpl;
import org.apache.bval.jsr303.util.PathImpl;
import org.apache.bval.model.Validation;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;
import org.apache.bval.util.AccessStrategy;
import org.apache.commons.lang3.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintValidation<T extends Annotation>
implements Validation,
ConstraintDescriptor<T> {
    private final ConstraintValidator<T, ?> validator;
    private T annotation;
    private final AccessStrategy access;
    private final boolean reportFromComposite;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Set<ConstraintValidation<?>> composedConstraints;
    private final Class<?> owner;
    private Set<Class<?>> groups;
    private Set<Class<? extends Payload>> payload;
    private Class<? extends ConstraintValidator<T, ?>>[] validatorClasses;

    public ConstraintValidation(Class<? extends ConstraintValidator<T, ?>>[] validatorClasses, ConstraintValidator<T, ?> validator, T annotation, Class<?> owner, AccessStrategy access, boolean reportFromComposite) {
        this.validatorClasses = (Class[])ArrayUtils.clone((Object[])validatorClasses);
        this.validator = validator;
        this.annotation = annotation;
        this.owner = owner;
        this.access = access;
        this.reportFromComposite = reportFromComposite;
    }

    public ConstraintDescriptor<T> asSerializableDescriptor() {
        return new ConstraintDescriptorImpl(this);
    }

    void setGroups(Set<Class<?>> groups) {
        this.groups = groups;
        ConstraintAnnotationAttributes.GROUPS.put(this.attributes, groups.toArray(new Class[groups.size()]));
    }

    void setPayload(Set<Class<? extends Payload>> payload) {
        this.payload = payload;
        ConstraintAnnotationAttributes.PAYLOAD.put(this.attributes, payload.toArray(new Class[payload.size()]));
    }

    public boolean isReportAsSingleViolation() {
        return this.reportFromComposite;
    }

    public void addComposed(ConstraintValidation<?> aConstraintValidation) {
        if (this.composedConstraints == null) {
            this.composedConstraints = new HashSet();
        }
        this.composedConstraints.add(aConstraintValidation);
    }

    public <L extends ValidationListener> void validate(ValidationContext<L> context) {
        this.validate((GroupValidationContext)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(GroupValidationContext<?> context) {
        context.setConstraintValidation(this);
        if (!this.isMemberOf(context.getCurrentGroup().getGroup())) {
            return;
        }
        if (context.getCurrentOwner() != null && this.owner != context.getCurrentOwner()) {
            return;
        }
        if (this.validator != null && !context.collectValidated(this.validator)) {
            return;
        }
        if (context.getMetaProperty() != null && !this.isReachable(context)) {
            return;
        }
        if (this.isReportAsSingleViolation()) {
            boolean bl;
            ConstraintValidationListener listener = (ConstraintValidationListener)context.getListener();
            listener.beginReportAsSingle();
            boolean bl2 = listener.hasViolations();
            try {
                Iterator<ConstraintValidation<?>> composed = this.getComposingValidations().iterator();
                while (!bl && composed.hasNext()) {
                    composed.next().validate(context);
                    bl = listener.hasViolations();
                }
            }
            finally {
                listener.endReportAsSingle();
                context.setConstraintValidation(this);
            }
            if (bl) {
                ConstraintValidatorContextImpl jsrContext = new ConstraintValidatorContextImpl(context, this);
                this.addErrors(context, jsrContext);
                return;
            }
        } else {
            for (ConstraintValidation<T> constraintValidation : this.getComposingValidations()) {
                constraintValidation.validate(context);
            }
            context.setConstraintValidation(this);
        }
        if (this.validator != null) {
            ConstraintValidatorContextImpl jsrContext = new ConstraintValidatorContextImpl(context, this);
            ConstraintValidator<T, ?> constraintValidator = this.validator;
            if (!constraintValidator.isValid(context.getValidatedValue(), (ConstraintValidatorContext)jsrContext)) {
                this.addErrors(context, jsrContext);
            }
        }
    }

    public void initialize() {
        if (null != this.validator) {
            try {
                this.validator.initialize(this.annotation);
            }
            catch (RuntimeException e) {
                throw new ConstraintDefinitionException("Incorrect validator [" + this.validator.getClass().getCanonicalName() + "] for annotation " + this.annotation.annotationType().getCanonicalName(), (Throwable)e);
            }
        }
    }

    private boolean isReachable(GroupValidationContext<?> context) {
        PathImpl path = context.getPropertyPath();
        NodeImpl node = path.getLeafNode();
        PathImpl beanPath = path.getPathWithoutLeafNode();
        if (beanPath == null) {
            beanPath = PathImpl.create(null);
        }
        try {
            if (!context.getTraversableResolver().isReachable(context.getBean(), (Path.Node)node, context.getRootMetaBean().getBeanClass(), (Path)beanPath, this.access.getElementType())) {
                return false;
            }
        }
        catch (RuntimeException e) {
            throw new ValidationException("Error in TraversableResolver.isReachable() for " + context.getBean(), (Throwable)e);
        }
        return true;
    }

    private void addErrors(GroupValidationContext<?> context, ConstraintValidatorContextImpl jsrContext) {
        for (ValidationListener.Error each : jsrContext.getErrorMessages()) {
            ((ConstraintValidationListener)context.getListener()).addError(each, context);
        }
    }

    public String toString() {
        return "ConstraintValidation{" + this.validator + '}';
    }

    public String getMessageTemplate() {
        return (String)ConstraintAnnotationAttributes.MESSAGE.get(this.attributes);
    }

    public ConstraintValidator<T, ?> getValidator() {
        return this.validator;
    }

    protected boolean isMemberOf(Class<?> reqGroup) {
        return this.groups.contains(reqGroup);
    }

    public Class<?> getOwner() {
        return this.owner;
    }

    public T getAnnotation() {
        return this.annotation;
    }

    public AccessStrategy getAccess() {
        return this.access;
    }

    public void setAnnotation(T annotation) {
        this.annotation = annotation;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return this.composedConstraints == null ? Collections.EMPTY_SET : this.composedConstraints;
    }

    Set<ConstraintValidation<?>> getComposingValidations() {
        return this.composedConstraints == null ? Collections.EMPTY_SET : this.composedConstraints;
    }

    public Set<Class<?>> getGroups() {
        return this.groups;
    }

    public Set<Class<? extends Payload>> getPayload() {
        return this.payload;
    }

    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        if (this.validatorClasses == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.validatorClasses);
    }
}

