/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableSecurity is an enum
type OpcuaNodeIdServicesVariableSecurity int32

type IOpcuaNodeIdServicesVariableSecurity interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableSecurity_SecurityTokenRequestType_EnumStrings                                                                 OpcuaNodeIdServicesVariableSecurity = 7598
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_KeyLifetime                                    OpcuaNodeIdServicesVariableSecurity = 15010
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityPolicyUri                              OpcuaNodeIdServicesVariableSecurity = 15011
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxFutureKeyCount                              OpcuaNodeIdServicesVariableSecurity = 15012
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxPastKeyCount                                OpcuaNodeIdServicesVariableSecurity = 15043
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_KeyLifetime                                                                        OpcuaNodeIdServicesVariableSecurity = 15046
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_SecurityPolicyUri                                                                  OpcuaNodeIdServicesVariableSecurity = 15047
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_MaxFutureKeyCount                                                                  OpcuaNodeIdServicesVariableSecurity = 15048
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_MaxPastKeyCount                                                                    OpcuaNodeIdServicesVariableSecurity = 15056
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_InputArguments          OpcuaNodeIdServicesVariableSecurity = 15455
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_OutputArguments         OpcuaNodeIdServicesVariableSecurity = 15456
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup_InputArguments       OpcuaNodeIdServicesVariableSecurity = 15458
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityGroupId                                OpcuaNodeIdServicesVariableSecurity = 15460
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroup_InputArguments                                              OpcuaNodeIdServicesVariableSecurity = 15462
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroup_OutputArguments                                             OpcuaNodeIdServicesVariableSecurity = 15463
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_RemoveSecurityGroup_InputArguments                                           OpcuaNodeIdServicesVariableSecurity = 15465
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_SecurityGroupId                                                                    OpcuaNodeIdServicesVariableSecurity = 15472
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_InputArguments    OpcuaNodeIdServicesVariableSecurity = 25294
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_OutputArguments   OpcuaNodeIdServicesVariableSecurity = 25295
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder_InputArguments OpcuaNodeIdServicesVariableSecurity = 25297
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_SupportedSecurityPolicyUris              OpcuaNodeIdServicesVariableSecurity = 25298
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroupFolder_InputArguments                                        OpcuaNodeIdServicesVariableSecurity = 25313
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroupFolder_OutputArguments                                       OpcuaNodeIdServicesVariableSecurity = 25314
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_RemoveSecurityGroupFolder_InputArguments                                     OpcuaNodeIdServicesVariableSecurity = 25316
	OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SupportedSecurityPolicyUris                                                  OpcuaNodeIdServicesVariableSecurity = 25317
)

var OpcuaNodeIdServicesVariableSecurityValues []OpcuaNodeIdServicesVariableSecurity

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableSecurityValues = []OpcuaNodeIdServicesVariableSecurity{
		OpcuaNodeIdServicesVariableSecurity_SecurityTokenRequestType_EnumStrings,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_KeyLifetime,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityPolicyUri,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxFutureKeyCount,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxPastKeyCount,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_KeyLifetime,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_SecurityPolicyUri,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_MaxFutureKeyCount,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_MaxPastKeyCount,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_OutputArguments,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityGroupId,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroup_OutputArguments,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_RemoveSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_SecurityGroupId,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_InputArguments,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_OutputArguments,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder_InputArguments,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_SupportedSecurityPolicyUris,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroupFolder_InputArguments,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroupFolder_OutputArguments,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_RemoveSecurityGroupFolder_InputArguments,
		OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SupportedSecurityPolicyUris,
	}
}

func OpcuaNodeIdServicesVariableSecurityByValue(value int32) (enum OpcuaNodeIdServicesVariableSecurity, ok bool) {
	switch value {
	case 15010:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_KeyLifetime, true
	case 15011:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityPolicyUri, true
	case 15012:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxFutureKeyCount, true
	case 15043:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxPastKeyCount, true
	case 15046:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_KeyLifetime, true
	case 15047:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_SecurityPolicyUri, true
	case 15048:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_MaxFutureKeyCount, true
	case 15056:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_MaxPastKeyCount, true
	case 15455:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_InputArguments, true
	case 15456:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_OutputArguments, true
	case 15458:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup_InputArguments, true
	case 15460:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityGroupId, true
	case 15462:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroup_InputArguments, true
	case 15463:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroup_OutputArguments, true
	case 15465:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_RemoveSecurityGroup_InputArguments, true
	case 15472:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_SecurityGroupId, true
	case 25294:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_InputArguments, true
	case 25295:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_OutputArguments, true
	case 25297:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder_InputArguments, true
	case 25298:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_SupportedSecurityPolicyUris, true
	case 25313:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroupFolder_InputArguments, true
	case 25314:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroupFolder_OutputArguments, true
	case 25316:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_RemoveSecurityGroupFolder_InputArguments, true
	case 25317:
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SupportedSecurityPolicyUris, true
	case 7598:
		return OpcuaNodeIdServicesVariableSecurity_SecurityTokenRequestType_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableSecurityByName(value string) (enum OpcuaNodeIdServicesVariableSecurity, ok bool) {
	switch value {
	case "SecurityGroupFolderType_SecurityGroupName_Placeholder_KeyLifetime":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_KeyLifetime, true
	case "SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityPolicyUri":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityPolicyUri, true
	case "SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxFutureKeyCount":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxFutureKeyCount, true
	case "SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxPastKeyCount":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxPastKeyCount, true
	case "SecurityGroupType_KeyLifetime":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_KeyLifetime, true
	case "SecurityGroupType_SecurityPolicyUri":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_SecurityPolicyUri, true
	case "SecurityGroupType_MaxFutureKeyCount":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_MaxFutureKeyCount, true
	case "SecurityGroupType_MaxPastKeyCount":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_MaxPastKeyCount, true
	case "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_InputArguments, true
	case "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_OutputArguments":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_OutputArguments, true
	case "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup_InputArguments, true
	case "SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityGroupId":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityGroupId, true
	case "SecurityGroupFolderType_AddSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroup_InputArguments, true
	case "SecurityGroupFolderType_AddSecurityGroup_OutputArguments":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroup_OutputArguments, true
	case "SecurityGroupFolderType_RemoveSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_RemoveSecurityGroup_InputArguments, true
	case "SecurityGroupType_SecurityGroupId":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_SecurityGroupId, true
	case "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_InputArguments":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_InputArguments, true
	case "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_OutputArguments":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_OutputArguments, true
	case "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder_InputArguments":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder_InputArguments, true
	case "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_SupportedSecurityPolicyUris":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_SupportedSecurityPolicyUris, true
	case "SecurityGroupFolderType_AddSecurityGroupFolder_InputArguments":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroupFolder_InputArguments, true
	case "SecurityGroupFolderType_AddSecurityGroupFolder_OutputArguments":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroupFolder_OutputArguments, true
	case "SecurityGroupFolderType_RemoveSecurityGroupFolder_InputArguments":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_RemoveSecurityGroupFolder_InputArguments, true
	case "SecurityGroupFolderType_SupportedSecurityPolicyUris":
		return OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SupportedSecurityPolicyUris, true
	case "SecurityTokenRequestType_EnumStrings":
		return OpcuaNodeIdServicesVariableSecurity_SecurityTokenRequestType_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableSecurityKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableSecurityValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableSecurity(structType any) OpcuaNodeIdServicesVariableSecurity {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableSecurity {
		if sOpcuaNodeIdServicesVariableSecurity, ok := typ.(OpcuaNodeIdServicesVariableSecurity); ok {
			return sOpcuaNodeIdServicesVariableSecurity
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableSecurity) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableSecurity) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableSecurityParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableSecurity, error) {
	return OpcuaNodeIdServicesVariableSecurityParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableSecurityParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableSecurity, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableSecurity", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableSecurity")
	}
	if enum, ok := OpcuaNodeIdServicesVariableSecurityByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableSecurity")
		return OpcuaNodeIdServicesVariableSecurity(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableSecurity) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableSecurity) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableSecurity", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableSecurity) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableSecurity) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_KeyLifetime:
		return "SecurityGroupFolderType_SecurityGroupName_Placeholder_KeyLifetime"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityPolicyUri:
		return "SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityPolicyUri"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxFutureKeyCount:
		return "SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxFutureKeyCount"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxPastKeyCount:
		return "SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxPastKeyCount"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_KeyLifetime:
		return "SecurityGroupType_KeyLifetime"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_SecurityPolicyUri:
		return "SecurityGroupType_SecurityPolicyUri"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_MaxFutureKeyCount:
		return "SecurityGroupType_MaxFutureKeyCount"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_MaxPastKeyCount:
		return "SecurityGroupType_MaxPastKeyCount"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_InputArguments:
		return "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_OutputArguments:
		return "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_OutputArguments"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup_InputArguments:
		return "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityGroupId:
		return "SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityGroupId"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroup_InputArguments:
		return "SecurityGroupFolderType_AddSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroup_OutputArguments:
		return "SecurityGroupFolderType_AddSecurityGroup_OutputArguments"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_RemoveSecurityGroup_InputArguments:
		return "SecurityGroupFolderType_RemoveSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupType_SecurityGroupId:
		return "SecurityGroupType_SecurityGroupId"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_InputArguments:
		return "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_InputArguments"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_OutputArguments:
		return "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_OutputArguments"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder_InputArguments:
		return "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder_InputArguments"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_SupportedSecurityPolicyUris:
		return "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_SupportedSecurityPolicyUris"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroupFolder_InputArguments:
		return "SecurityGroupFolderType_AddSecurityGroupFolder_InputArguments"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_AddSecurityGroupFolder_OutputArguments:
		return "SecurityGroupFolderType_AddSecurityGroupFolder_OutputArguments"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_RemoveSecurityGroupFolder_InputArguments:
		return "SecurityGroupFolderType_RemoveSecurityGroupFolder_InputArguments"
	case OpcuaNodeIdServicesVariableSecurity_SecurityGroupFolderType_SupportedSecurityPolicyUris:
		return "SecurityGroupFolderType_SupportedSecurityPolicyUris"
	case OpcuaNodeIdServicesVariableSecurity_SecurityTokenRequestType_EnumStrings:
		return "SecurityTokenRequestType_EnumStrings"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableSecurity) String() string {
	return e.PLC4XEnumName()
}
