/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum VirtualLanPriority {
  BEST_EFFORT((byte) 0x0, (String) "BE"),
  BACKGROUND((byte) 0x1, (String) "BK"),
  EXCELLENT_EFFORT((byte) 0x2, (String) "EE"),
  CRITICAL_APPLICATIONS((byte) 0x3, (String) "CA"),
  VIDEO((byte) 0x4, (String) "VI"),
  VOICE((byte) 0x5, (String) "VO"),
  INTERNETWORK_CONTROL((byte) 0x6, (String) "IC"),
  NETWORK_CONTROL((byte) 0x7, (String) "NC");
  private static final Map<Byte, VirtualLanPriority> map;

  static {
    map = new HashMap<>();
    for (VirtualLanPriority value : VirtualLanPriority.values()) {
      map.put((byte) value.getValue(), value);
    }
  }

  private final byte value;
  private final String acronym;

  VirtualLanPriority(byte value, String acronym) {
    this.value = value;
    this.acronym = acronym;
  }

  public byte getValue() {
    return value;
  }

  public String getAcronym() {
    return acronym;
  }

  public static VirtualLanPriority firstEnumForFieldAcronym(String fieldValue) {
    for (VirtualLanPriority _val : VirtualLanPriority.values()) {
      if (_val.getAcronym().equals(fieldValue)) {
        return _val;
      }
    }
    return null;
  }

  public static List<VirtualLanPriority> enumsForFieldAcronym(String fieldValue) {
    List<VirtualLanPriority> _values = new ArrayList<>();
    for (VirtualLanPriority _val : VirtualLanPriority.values()) {
      if (_val.getAcronym().equals(fieldValue)) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static VirtualLanPriority enumForValue(byte value) {
    return map.get(value);
  }

  public static Boolean isDefined(byte value) {
    return map.containsKey(value);
  }
}
