/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class UtilAll {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");
    private static final Logger STORE_LOG = LoggerFactory.getLogger((String)"RocketmqStore");
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd#HH:mm:ss:SSS";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final int PID;

    public static int getPid() {
        return PID;
    }

    public static void sleep(long sleepMs) {
        UtilAll.sleep(sleepMs, TimeUnit.MILLISECONDS);
    }

    public static void sleep(long timeOut, TimeUnit timeUnit) {
        if (null == timeUnit) {
            return;
        }
        try {
            timeUnit.sleep(timeOut);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String currentStackTrace() {
        StackTraceElement[] stackTrace;
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement ste : stackTrace = Thread.currentThread().getStackTrace()) {
            sb.append("\n\t");
            sb.append(ste.toString());
        }
        return sb.toString();
    }

    public static String offset2FileName(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public static long computeElapsedTimeMilliseconds(long beginTime) {
        return System.currentTimeMillis() - beginTime;
    }

    public static boolean isItTimeToDo(String when) {
        String[] whiles = when.split(";");
        if (whiles.length > 0) {
            Calendar now = Calendar.getInstance();
            for (String w : whiles) {
                int nowHour = Integer.parseInt(w);
                if (nowHour != now.get(11)) continue;
                return true;
            }
        }
        return false;
    }

    public static String timeMillisToHumanString() {
        return UtilAll.timeMillisToHumanString(System.currentTimeMillis());
    }

    public static String timeMillisToHumanString(long t) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(t);
        return String.format("%04d%02d%02d%02d%02d%02d%03d", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    public static long computeNextMorningTimeMillis() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long computeNextMinutesTimeMillis() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(5, 0);
        cal.add(11, 0);
        cal.add(12, 1);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long computeNextHourTimeMillis() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(5, 0);
        cal.add(11, 1);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long computeNextHalfHourTimeMillis() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(5, 0);
        cal.add(11, 1);
        cal.set(12, 30);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static String timeMillisToHumanString2(long t) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(t);
        return String.format("%04d-%02d-%02d %02d:%02d:%02d,%03d", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    public static String timeMillisToHumanString3(long t) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(t);
        return String.format("%04d%02d%02d%02d%02d%02d", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    public static long getTotalSpace(String path) {
        if (null == path || path.isEmpty()) {
            return -1L;
        }
        try {
            File file = new File(path);
            if (!file.exists()) {
                return -1L;
            }
            return file.getTotalSpace();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static boolean isPathExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static double getDiskPartitionSpaceUsedPercent(String path) {
        if (null == path || path.isEmpty()) {
            STORE_LOG.error("Error when measuring disk space usage, path is null or empty, path : {}", (Object)path);
            return -1.0;
        }
        try {
            File file = new File(path);
            if (!file.exists()) {
                STORE_LOG.error("Error when measuring disk space usage, file doesn't exist on this path: {}", (Object)path);
                return -1.0;
            }
            long totalSpace = file.getTotalSpace();
            if (totalSpace > 0L) {
                long usedSpace = totalSpace - file.getFreeSpace();
                long usableSpace = file.getUsableSpace();
                long entireSpace = usedSpace + usableSpace;
                long roundNum = 0L;
                if (usedSpace * 100L % entireSpace != 0L) {
                    roundNum = 1L;
                }
                long result = usedSpace * 100L / entireSpace + roundNum;
                return (double)result / 100.0;
            }
        }
        catch (Exception e) {
            STORE_LOG.error("Error when measuring disk space usage, got exception: :", (Throwable)e);
            return -1.0;
        }
        return -1.0;
    }

    public static long getDiskPartitionTotalSpace(String path) {
        if (null == path || path.isEmpty()) {
            return -1L;
        }
        try {
            File file = new File(path);
            if (!file.exists()) {
                return -1L;
            }
            return file.getTotalSpace() - file.getFreeSpace() + file.getUsableSpace();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static int crc32(byte[] array) {
        if (array != null) {
            return UtilAll.crc32(array, 0, array.length);
        }
        return 0;
    }

    public static int crc32(byte[] array, int offset, int length) {
        CRC32 crc32 = new CRC32();
        crc32.update(array, offset, length);
        return (int)(crc32.getValue() & Integer.MAX_VALUE);
    }

    public static String bytes2string(byte[] src) {
        char[] hexChars = new char[src.length * 2];
        for (int j = 0; j < src.length; ++j) {
            int v = src[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void writeInt(char[] buffer, int pos, int value) {
        char[] hexArray = HEX_ARRAY;
        for (int moveBits = 28; moveBits >= 0; moveBits -= 4) {
            buffer[pos++] = hexArray[value >>> moveBits & 0xF];
        }
    }

    public static void writeShort(char[] buffer, int pos, int value) {
        char[] hexArray = HEX_ARRAY;
        for (int moveBits = 12; moveBits >= 0; moveBits -= 4) {
            buffer[pos++] = hexArray[value >>> moveBits & 0xF];
        }
    }

    public static byte[] string2bytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(UtilAll.charToByte(hexChars[pos]) << 4 | UtilAll.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    @Deprecated
    public static byte[] uncompress(byte[] src) throws IOException {
        byte[] result = src;
        byte[] uncompressData = new byte[src.length];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(src);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);
        try {
            int len;
            while ((len = inflaterInputStream.read(uncompressData, 0, uncompressData.length)) > 0) {
                byteArrayOutputStream.write(uncompressData, 0, len);
            }
            byteArrayOutputStream.flush();
            result = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException e) {
                log.error("Failed to close the stream", (Throwable)e);
            }
            try {
                inflaterInputStream.close();
            }
            catch (IOException e) {
                log.error("Failed to close the stream", (Throwable)e);
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                log.error("Failed to close the stream", (Throwable)e);
            }
        }
        return result;
    }

    @Deprecated
    public static byte[] compress(byte[] src, int level) throws IOException {
        byte[] result = src;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);
        Deflater defeater = new Deflater(level);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, defeater);
        try {
            deflaterOutputStream.write(src);
            deflaterOutputStream.finish();
            deflaterOutputStream.close();
            result = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            defeater.end();
            throw e;
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            defeater.end();
        }
        return result;
    }

    public static int asInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long asLong(String str, long defaultValue) {
        try {
            return Long.parseLong(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }

    public static Date parseDate(String date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String responseCode2String(int code) {
        return Integer.toString(code);
    }

    public static String frontStringAtLeast(String str, int size) {
        if (str != null && str.length() > size) {
            return str.substring(0, size);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        return StringUtils.isBlank((CharSequence)str);
    }

    public static String jstack() {
        return UtilAll.jstack(Thread.getAllStackTraces());
    }

    public static String jstack(Map<Thread, StackTraceElement[]> map) {
        StringBuilder result = new StringBuilder();
        try {
            for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                StackTraceElement[] elements = entry.getValue();
                Thread thread = entry.getKey();
                if (elements == null || elements.length <= 0) continue;
                String threadName = entry.getKey().getName();
                result.append(String.format("%-40sTID: %d STATE: %s%n", new Object[]{threadName, thread.getId(), thread.getState()}));
                for (StackTraceElement el : elements) {
                    result.append(String.format("%-40s%s%n", threadName, el.toString()));
                }
                result.append("\n");
            }
        }
        catch (Throwable e) {
            result.append(UtilAll.exceptionSimpleDesc(e));
        }
        return result.toString();
    }

    public static String exceptionSimpleDesc(Throwable e) {
        StringBuilder sb = new StringBuilder();
        if (e != null) {
            sb.append(e);
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                StackTraceElement element = stackTrace[0];
                sb.append(", ");
                sb.append(element.toString());
            }
        }
        return sb.toString();
    }

    public static boolean isInternalIP(byte[] ip) {
        if (ip.length != 4) {
            throw new RuntimeException("illegal ipv4 bytes");
        }
        if (ip[0] == 10) {
            return true;
        }
        if (ip[0] == 127) {
            return true;
        }
        return ip[0] == -84 ? ip[1] >= 16 && ip[1] <= 31 : ip[0] == -64 && ip[1] == -88;
    }

    public static boolean isInternalV6IP(InetAddress inetAddr) {
        return inetAddr.isAnyLocalAddress() || inetAddr.isLinkLocalAddress() || inetAddr.isLoopbackAddress() || inetAddr.isSiteLocalAddress();
    }

    private static boolean ipCheck(byte[] ip) {
        if (ip.length != 4) {
            throw new RuntimeException("illegal ipv4 bytes");
        }
        InetAddressValidator validator = InetAddressValidator.getInstance();
        return validator.isValidInet4Address(UtilAll.ipToIPv4Str(ip));
    }

    private static boolean ipV6Check(byte[] ip) {
        if (ip.length != 16) {
            throw new RuntimeException("illegal ipv6 bytes");
        }
        InetAddressValidator validator = InetAddressValidator.getInstance();
        return validator.isValidInet6Address(UtilAll.ipToIPv6Str(ip));
    }

    public static String ipToIPv4Str(byte[] ip) {
        if (ip.length != 4) {
            return null;
        }
        return (ip[0] & 0xFF) + "." + (ip[1] & 0xFF) + "." + (ip[2] & 0xFF) + "." + (ip[3] & 0xFF);
    }

    public static String ipToIPv6Str(byte[] ip) {
        if (ip.length != 16) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ip.length; ++i) {
            String hex = Integer.toHexString(ip[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
            if (i % 2 != 1 || i >= ip.length - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    public static byte[] getIP() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            byte[] internalIP = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    byte[] ipByte;
                    ip = addresses.nextElement();
                    if (ip != null && ip instanceof Inet4Address) {
                        ipByte = ip.getAddress();
                        if (ipByte.length != 4 || !UtilAll.ipCheck(ipByte)) continue;
                        if (!UtilAll.isInternalIP(ipByte)) {
                            return ipByte;
                        }
                        if (internalIP != null && internalIP[0] != 127) continue;
                        internalIP = ipByte;
                        continue;
                    }
                    if (ip == null || !(ip instanceof Inet6Address) || (ipByte = ip.getAddress()).length != 16 || !UtilAll.ipV6Check(ipByte) || UtilAll.isInternalV6IP(ip)) continue;
                    return ipByte;
                }
            }
            if (internalIP != null) {
                return internalIP;
            }
            throw new RuntimeException("Can not get local ip");
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get local ip", e);
        }
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files;
            for (File file1 : files = file.listFiles()) {
                UtilAll.deleteFile(file1);
            }
            file.delete();
        }
    }

    public static String join(List<String> list, String splitter) {
        if (list == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            str.append(list.get(i));
            if (i == list.size() - 1) break;
            str.append(splitter);
        }
        return str.toString();
    }

    public static List<String> split(String str, String splitter) {
        if (str == null) {
            return null;
        }
        String[] addrArray = str.split(splitter);
        return Arrays.asList(addrArray);
    }

    public static void deleteEmptyDirectory(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        File[] files = file.listFiles();
        if (files == null || files.length <= 0) {
            file.delete();
            STORE_LOG.info("delete empty direct, {}", (Object)file.getPath());
        }
    }

    public static void cleanBuffer(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect() || buffer.capacity() == 0) {
            return;
        }
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9)) {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                Unsafe unsafe = (Unsafe)field.get(null);
                Method cleaner = UtilAll.method(unsafe, "invokeCleaner", new Class[]{ByteBuffer.class});
                cleaner.invoke((Object)unsafe, UtilAll.viewed(buffer));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            UtilAll.invoke(UtilAll.invoke(UtilAll.viewed(buffer), "cleaner", new Class[0]), "clean", new Class[0]);
        }
    }

    public static Object invoke(final Object target, final String methodName, final Class<?> ... args) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method method = UtilAll.method(target, methodName, args);
                    method.setAccessible(true);
                    return method.invoke(target, new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    public static Method method(Object target, String methodName, Class<?>[] args) throws NoSuchMethodException {
        try {
            return target.getClass().getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            return target.getClass().getDeclaredMethod(methodName, args);
        }
    }

    private static ByteBuffer viewed(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("buffer is non-direct");
        }
        ByteBuffer viewedBuffer = (ByteBuffer)((DirectBuffer)((Object)buffer)).attachment();
        if (viewedBuffer == null) {
            return buffer;
        }
        return UtilAll.viewed(viewedBuffer);
    }

    public static void ensureDirOK(String dirName) {
        if (dirName != null) {
            if (dirName.contains(MixAll.MULTI_PATH_SPLITTER)) {
                String[] dirs;
                for (String dir : dirs = dirName.trim().split(MixAll.MULTI_PATH_SPLITTER)) {
                    UtilAll.createDirIfNotExist(dir);
                }
            } else {
                UtilAll.createDirIfNotExist(dirName);
            }
        }
    }

    private static void createDirIfNotExist(String dirName) {
        File f = new File(dirName);
        if (!f.exists()) {
            boolean result = f.mkdirs();
            STORE_LOG.info(dirName + " mkdir " + (result ? "OK" : "Failed"));
        }
    }

    static {
        Supplier<Integer> supplier = () -> {
            String currentJVM = ManagementFactory.getRuntimeMXBean().getName();
            try {
                return Integer.parseInt(currentJVM.substring(0, currentJVM.indexOf(64)));
            }
            catch (Exception e) {
                return -1;
            }
        };
        PID = supplier.get();
    }
}

