/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.freemarker.internal;

import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.Reader;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.freemarker.internal.FreemarkerScriptEngineFactory;

public class FreemarkerScriptEngine
extends AbstractSlingScriptEngine {
    private final FreemarkerScriptEngineFactory freemarkerScriptEngineFactory;
    private final Logger logger = Logger.getLogger((String)FreemarkerScriptEngine.class.getName());

    public FreemarkerScriptEngine(FreemarkerScriptEngineFactory freemarkerScriptEngineFactory) {
        super((ScriptEngineFactory)((Object)freemarkerScriptEngineFactory));
        this.freemarkerScriptEngineFactory = freemarkerScriptEngineFactory;
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        Bindings bindings = scriptContext.getBindings(100);
        SlingScriptHelper helper = (SlingScriptHelper)bindings.get("sling");
        if (helper == null) {
            throw new ScriptException("SlingScriptHelper missing from bindings");
        }
        bindings.putAll((Map<? extends String, ? extends Object>)this.freemarkerScriptEngineFactory.getTemplateModels());
        String scriptName = helper.getScript().getScriptResource().getPath();
        Configuration configuration = this.freemarkerScriptEngineFactory.getConfiguration();
        try {
            Template template = new Template(scriptName, reader, configuration);
            template.process((Object)bindings, scriptContext.getWriter());
        }
        catch (Throwable t) {
            String message = String.format("Failure processing FreeMarker template %s.", scriptName);
            this.logger.error(message, t);
            throw new ScriptException(message);
        }
        return null;
    }
}

