/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.resource;

import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public abstract class AbstractJcrNamespaceTest {
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());

    protected abstract ResourceResolverType getResourceResolverType();

    @Test
    public void testSling4362() throws RepositoryException {
        BundleContext bundleContext = MockOsgi.newBundleContext();
        ResourceResolver resolver = MockSling.newResourceResolver((ResourceResolverType)this.getResourceResolverType(), (BundleContext)bundleContext);
        ContentLoader contentLoader = new ContentLoader(resolver);
        contentLoader.json("/json-import-samples/SLING-4362.json", this.context.uniqueRoot().content() + "/foo");
        Resource resource = resolver.getResource(this.context.uniqueRoot().content() + "/foo");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource);
        Assert.assertEquals((Object)"fooType", (Object)props.get((Object)"sling:resourceType"));
        Assert.assertEquals((Object)"fooType", (Object)resource.getResourceType());
        MockOsgi.shutdown((BundleContext)bundleContext);
    }

    @Test
    public void testSling4362_ViaContextRule() throws RepositoryException {
        ResourceResolver resolver = this.context.resourceResolver();
        ContentLoader contentLoader = new ContentLoader(resolver);
        contentLoader.json("/json-import-samples/SLING-4362.json", this.context.uniqueRoot().content() + "/foo");
        Resource resource = resolver.getResource(this.context.uniqueRoot().content() + "/foo");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource);
        Assert.assertEquals((Object)"fooType", (Object)props.get((Object)"sling:resourceType"));
        Assert.assertEquals((Object)"fooType", (Object)resource.getResourceType());
    }
}

