/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.internal.gzip;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.tapestry5.http.internal.gzip.BufferedGZipOutputStream;
import org.apache.tapestry5.http.services.CompressionAnalyzer;

public class GZIPEnabledResponse
extends HttpServletResponseWrapper {
    private final int cutover;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final CompressionAnalyzer analyzer;
    private boolean contentLengthSet = false;

    public GZIPEnabledResponse(HttpServletResponse response, HttpServletRequest request, int cutover, CompressionAnalyzer analyzer) {
        super(response);
        this.request = request;
        this.response = response;
        this.cutover = cutover;
        this.analyzer = analyzer;
    }

    public void setContentLength(int len) {
        super.setContentLength(len);
        this.contentLengthSet = true;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.contentLengthSet || this.isCompressionDisabled()) {
            return super.getOutputStream();
        }
        String contentType = this.getContentType();
        return new BufferedGZipOutputStream(contentType, this.response, this.cutover, this.analyzer);
    }

    private boolean isCompressionDisabled() {
        return this.request.getAttribute("tapestry.supress-compression") != null;
    }
}

