/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.list.TypeListExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimAction
extends AbstractRutaAction {
    private TypeListExpression typeList;
    private List<TypeExpression> types;

    public TrimAction(List<TypeExpression> types, TypeListExpression typeList) {
        this.types = types;
        this.typeList = typeList;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        List<AnnotationFS> matchedAnnotationsOf = match.getMatchedAnnotationsOf(element, stream);
        List<Type> typesToTrim = this.getTypes(element.getParent());
        for (AnnotationFS annotationFS : matchedAnnotationsOf) {
            this.trimAnnotation(annotationFS, typesToTrim, match, stream);
        }
    }

    private void trimAnnotation(AnnotationFS annotation, List<Type> typesToTrim, RuleMatch match, RutaStream stream) {
        int oldBegin = annotation.getBegin();
        int oldEnd = annotation.getEnd();
        int newBegin = oldBegin;
        int newEnd = oldEnd;
        RutaBasic beginBasic = stream.getBeginAnchor(oldBegin);
        while (this.isPartof(beginBasic, typesToTrim) && beginBasic.getBegin() < oldEnd) {
            beginBasic = stream.getBasicNextTo(false, (AnnotationFS)beginBasic);
        }
        newBegin = beginBasic.getBegin();
        RutaBasic endBasic = stream.getEndAnchor(oldEnd);
        while (this.isPartof(endBasic, typesToTrim) && endBasic.getEnd() > newBegin) {
            endBasic = stream.getBasicNextTo(true, (AnnotationFS)endBasic);
        }
        newEnd = endBasic.getEnd();
        if (oldBegin != newBegin || newEnd != oldEnd) {
            stream.removeAnnotation(annotation);
            if (annotation instanceof Annotation) {
                Annotation a = (Annotation)annotation;
                a.setBegin(newBegin);
                a.setEnd(newEnd);
            }
            if (newBegin < newEnd) {
                stream.addAnnotation(annotation, true, match);
            }
        }
    }

    private boolean isPartof(RutaBasic basic, List<Type> typesToTrim) {
        for (Type type : typesToTrim) {
            boolean partOf = basic.isPartOf(type);
            if (!partOf) continue;
            return true;
        }
        return false;
    }

    private List<Type> getTypes(RutaStatement parent) {
        List<Object> result = new ArrayList<Type>();
        if (this.types != null) {
            for (TypeExpression each : this.types) {
                result.add(each.getType(parent));
            }
        } else if (this.typeList != null) {
            result = this.typeList.getList(parent);
        }
        return result;
    }

    public TypeListExpression getTypeList() {
        return this.typeList;
    }

    public List<TypeExpression> getTypes() {
        return this.types;
    }
}

