/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.network.Network;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.User;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;

public class Tool
extends ElectricObject {
    private String toolName;
    private int toolState;
    private int toolIndex;
    private static List tools = new ArrayList();
    private static List listeners = new ArrayList();
    private static int toolNumber = 0;
    public Preferences prefs;
    private static final int TOOLON = 1;
    private static final int TOOLBG = 2;
    private static final int TOOLFIX = 4;
    private static final int TOOLINCREMENTAL = 16;
    private static final int TOOLANALYSIS = 32;
    private static final int TOOLSYNTHESIS = 64;

    protected Tool(String toolName) {
        this.toolName = toolName;
        this.toolState = 0;
        this.toolIndex = toolNumber++;
        tools.add(this);
        this.prefs = Preferences.userNodeForPackage(this.getClass());
    }

    private void updateListeners() {
        listeners.clear();
        Iterator it = tools.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Listener) || !((Listener)o).isOn()) continue;
            listeners.add(o);
        }
    }

    public static void initAllTools() {
        User.tool.init();
        Network.tool.init();
        LETool.tool.init();
        Simulation.tool.init();
        Routing.tool.init();
        IOTool.tool.init();
        DRC.tool.init();
        ERC.tool.init();
    }

    public static Tool findTool(String name) {
        for (int i = 0; i < tools.size(); ++i) {
            Tool t = (Tool)tools.get(i);
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public static Iterator getTools() {
        return tools.iterator();
    }

    public static int getNumTools() {
        return tools.size();
    }

    public static Iterator getListeners() {
        return listeners.iterator();
    }

    public String getName() {
        return this.toolName;
    }

    public int getIndex() {
        return this.toolIndex;
    }

    public void setOn() {
        this.toolState |= 1;
        this.updateListeners();
    }

    public void clearOn() {
        this.toolState &= 0xFFFFFFFE;
        this.updateListeners();
    }

    public boolean isOn() {
        return (this.toolState & 1) != 0;
    }

    public void setBackground() {
        this.toolState |= 2;
    }

    public void clearBackground() {
        this.toolState &= 0xFFFFFFFD;
    }

    public boolean isBackground() {
        return (this.toolState & 2) != 0;
    }

    public void setFixErrors() {
        this.toolState |= 4;
    }

    public void clearFixErrors() {
        this.toolState &= 0xFFFFFFFB;
    }

    public boolean isFixErrors() {
        return (this.toolState & 4) != 0;
    }

    public void setIncremental() {
        this.toolState |= 0x10;
    }

    public void clearIncremental() {
        this.toolState &= 0xFFFFFFEF;
    }

    public boolean isIncremental() {
        return (this.toolState & 0x10) != 0;
    }

    public void setAnalysis() {
        this.toolState |= 0x20;
    }

    public void clearAnalysis() {
        this.toolState &= 0xFFFFFFDF;
    }

    public boolean isAnalysis() {
        return (this.toolState & 0x20) != 0;
    }

    public void setSynthesis() {
        this.toolState |= 0x40;
    }

    public void clearSynthesis() {
        this.toolState &= 0xFFFFFFBF;
    }

    public boolean isSynthesis() {
        return (this.toolState & 0x40) != 0;
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        String name = key.getName();
        return name.equals("NET_auto_name") || name.equals("NET_use_port_names") || name.equals("NET_compare_hierarchy") || name.equals("D") || name.equals("<") || name.equals("USER_alignment_obj") || name.equals("USER_alignment_edge") || name.equals("s") || name.equals("DRC_pointout");
    }

    public String toString() {
        return "Tool '" + this.toolName + "'";
    }

    public void setVarInJob(ElectricObject obj, Variable.Key key, Object newVal) {
        SetVarJob job = new SetVarJob(this, obj, key, newVal);
    }

    public void init() {
    }

    private static class SetVarJob
    extends Job {
        ElectricObject obj;
        Variable.Key key;
        Object newVal;

        protected SetVarJob(Tool tool, ElectricObject obj, Variable.Key key, Object newVal) {
            super("Add Variable", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.obj = obj;
            this.key = key;
            this.newVal = newVal;
            this.startJob();
        }

        public boolean doIt() {
            this.obj.newVar(this.key, this.newVal);
            return true;
        }
    }
}

