/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class AttributesTable
extends JTable {
    private JComboBox codeComboBox;
    static /* synthetic */ Class class$com$sun$electric$database$variable$Variable$Code;
    static /* synthetic */ Class class$java$lang$String;

    public AttributesTable(boolean showCode) {
        TableColumn codeColumn;
        this.setGridColor(this.getBackground());
        this.setSelectionMode(0);
        this.setModel(new VariableTableModel(showCode));
        if (showCode) {
            this.codeComboBox = new JComboBox();
            Iterator it = Variable.Code.getCodes();
            while (it.hasNext()) {
                this.codeComboBox.addItem(it.next());
            }
            this.codeComboBox.setFont(new Font("Dialog", 0, 12));
        }
        if ((codeColumn = this.getColumnModel().getColumn(2)) != null) {
            codeColumn.setCellEditor(new DefaultCellEditor(this.codeComboBox));
        }
    }

    public void addVariable(Variable var, ElectricObject owner) {
        ((VariableTableModel)this.getModel()).addVariable(var, owner);
    }

    public void clearVariables() {
        ((VariableTableModel)this.getModel()).clearVariables();
    }

    public static class VarChange
    extends Job {
        private Variable var;
        private ElectricObject owner;
        private Variable.Code code;
        private Object newValue;

        private VarChange(Variable var, ElectricObject owner, Variable.Code code, Object newValue) {
            super("VarChange", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.var = var;
            this.owner = owner;
            this.code = code;
            this.newValue = newValue;
            this.startJob();
        }

        public boolean doIt() {
            Variable v = this.owner.updateVar(this.var.getKey(), this.newValue);
            v.setCode(this.code);
            return true;
        }
    }

    private static class VariableTableModel
    extends AbstractTableModel {
        private List varInfos = new ArrayList();
        private boolean DEBUG = false;
        private static final String[] columnNames = new String[]{"Name", "Value", "Code"};
        private boolean showCode = true;

        private VariableTableModel(boolean showCode) {
            this.showCode = showCode;
        }

        public int getColumnCount() {
            int c = 2;
            if (this.showCode) {
                ++c;
            }
            return c;
        }

        public int getRowCount() {
            return this.varInfos.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            VarInfo vc = (VarInfo)this.varInfos.get(rowIndex);
            Variable var = vc.var;
            if (var == null) {
                return null;
            }
            if (columnIndex == 0) {
                if (this.DEBUG) {
                    return var.getKey().getName();
                }
                return var.getTrueName();
            }
            if (columnIndex == 1) {
                return var.getObject().toString();
            }
            if (columnIndex == 2 && this.showCode) {
                return var.getCode();
            }
            return null;
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public void setValueAt(Object aValue, int row, int col) {
            Variable.Code newCode;
            VarInfo vc = (VarInfo)this.varInfos.get(row);
            Variable var = vc.var;
            ElectricObject owner = vc.owner;
            if (var == null) {
                return;
            }
            if (owner == null) {
                return;
            }
            if (col == 1 && !aValue.toString().equals(var.getObject().toString())) {
                VarChange job = new VarChange(var, owner, var.getCode(), aValue);
                this.fireTableCellUpdated(row, col);
            }
            if (col == 2 && (newCode = (Variable.Code)aValue) != var.getCode()) {
                VarChange job = new VarChange(var, owner, newCode, var.getObject());
                this.fireTableCellUpdated(row, col);
            }
        }

        private void addVariable(Variable var, ElectricObject owner) {
            VarInfo vi = new VarInfo();
            vi.var = var;
            vi.owner = owner;
            this.varInfos.add(vi);
            this.fireTableDataChanged();
        }

        private void clearVariables() {
            this.varInfos.clear();
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int col) {
            if (col == 2) {
                return class$com$sun$electric$database$variable$Variable$Code == null ? (class$com$sun$electric$database$variable$Variable$Code = AttributesTable.class$("com.sun.electric.database.variable.Variable$Code")) : class$com$sun$electric$database$variable$Variable$Code;
            }
            return class$java$lang$String == null ? (class$java$lang$String = AttributesTable.class$("java.lang.String")) : class$java$lang$String;
        }

        private static class VarInfo {
            private Variable var;
            private ElectricObject owner;

            private VarInfo() {
            }
        }
    }
}

