/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.ncc.NCC;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class NCCTab
extends PreferencePanel {
    private boolean initialEnableSizeChecking;
    private double initialRelativeSizeTolerance;
    private double initialAbsoluteSizeTolerance;
    private boolean initialHaltAfterFindingFirstMismatchedCell;
    private JTextField absoluteSizeTolerance;
    private JPanel checkingAllCells;
    private JCheckBox enableSizeChecking;
    private ButtonGroup expandGroup;
    private JCheckBox haltAfterFindingFirstMismatchedCell;
    private JLabel jLabel75;
    private JLabel jLabel76;
    private ButtonGroup mergeParallelGroup;
    private ButtonGroup mergeSeriesGroup;
    private JPanel ncc;
    private JTextField relativeSizeTolerance;
    private JPanel sizeChecking;

    public NCCTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.ncc;
    }

    public String getName() {
        return "NCC";
    }

    public void init() {
        this.initialEnableSizeChecking = NCC.getCheckSizes();
        this.enableSizeChecking.setSelected(this.initialEnableSizeChecking);
        this.initialRelativeSizeTolerance = NCC.getRelativeSizeTolerance();
        this.relativeSizeTolerance.setText(Double.toString(this.initialRelativeSizeTolerance));
        this.initialAbsoluteSizeTolerance = NCC.getAbsoluteSizeTolerance();
        this.absoluteSizeTolerance.setText(Double.toString(this.initialAbsoluteSizeTolerance));
        this.initialHaltAfterFindingFirstMismatchedCell = NCC.getHaltAfterFirstMismatch();
        this.haltAfterFindingFirstMismatchedCell.setSelected(this.initialHaltAfterFindingFirstMismatchedCell);
        this.enableSizeChecking.setEnabled(false);
    }

    public void term() {
        boolean currentHaltAfterFindingFirstMismatchedCell;
        double currentAbsoluteSizeTolerance;
        double currentRelativeSizeTolerance;
        boolean currentEnableSizeChecking = this.enableSizeChecking.isSelected();
        if (currentEnableSizeChecking != this.initialEnableSizeChecking) {
            NCC.setCheckSizes(currentEnableSizeChecking);
        }
        if ((currentRelativeSizeTolerance = TextUtils.atof(this.relativeSizeTolerance.getText(), new Double(this.initialRelativeSizeTolerance))) != this.initialRelativeSizeTolerance) {
            NCC.setRelativeSizeTolerance(currentRelativeSizeTolerance);
        }
        if ((currentAbsoluteSizeTolerance = TextUtils.atof(this.absoluteSizeTolerance.getText(), new Double(this.initialAbsoluteSizeTolerance))) != this.initialAbsoluteSizeTolerance) {
            NCC.setAbsoluteSizeTolerance(currentAbsoluteSizeTolerance);
        }
        if ((currentHaltAfterFindingFirstMismatchedCell = this.haltAfterFindingFirstMismatchedCell.isSelected()) != this.initialHaltAfterFindingFirstMismatchedCell) {
            NCC.setHaltAfterFirstMismatch(currentHaltAfterFindingFirstMismatchedCell);
        }
    }

    private void initComponents() {
        this.expandGroup = new ButtonGroup();
        this.mergeParallelGroup = new ButtonGroup();
        this.mergeSeriesGroup = new ButtonGroup();
        this.ncc = new JPanel();
        this.sizeChecking = new JPanel();
        this.enableSizeChecking = new JCheckBox();
        this.jLabel75 = new JLabel();
        this.jLabel76 = new JLabel();
        this.relativeSizeTolerance = new JTextField();
        this.absoluteSizeTolerance = new JTextField();
        this.checkingAllCells = new JPanel();
        this.haltAfterFindingFirstMismatchedCell = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NCCTab.this.closeDialog(evt);
            }
        });
        this.ncc.setLayout(new GridBagLayout());
        this.sizeChecking.setLayout(new GridBagLayout());
        this.sizeChecking.setBorder(new TitledBorder("Size Checking"));
        this.enableSizeChecking.setText("Check sizes when NCCing a single pair of Cells flat");
        this.enableSizeChecking.setHorizontalTextPosition(10);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.sizeChecking.add((Component)this.enableSizeChecking, gridBagConstraints);
        this.jLabel75.setText("Relative size tolerance  (%):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.sizeChecking.add((Component)this.jLabel75, gridBagConstraints);
        this.jLabel76.setText("Absolute size tolerance (lambda):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.sizeChecking.add((Component)this.jLabel76, gridBagConstraints);
        this.relativeSizeTolerance.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.sizeChecking.add((Component)this.relativeSizeTolerance, gridBagConstraints);
        this.absoluteSizeTolerance.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.sizeChecking.add((Component)this.absoluteSizeTolerance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.sizeChecking, gridBagConstraints);
        this.checkingAllCells.setLayout(new GridBagLayout());
        this.checkingAllCells.setBorder(new TitledBorder("Checking All Cells"));
        this.haltAfterFindingFirstMismatchedCell.setText("Halt after finding the first mismatched Cell");
        this.haltAfterFindingFirstMismatchedCell.setActionCommand("Halt on First Mismatched Cell");
        this.haltAfterFindingFirstMismatchedCell.setHorizontalTextPosition(10);
        this.checkingAllCells.add((Component)this.haltAfterFindingFirstMismatchedCell, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.checkingAllCells, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.ncc, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

