/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.trees;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class LeafEquivRecords {
    private static final LeafList EMPTY_LIST = new LeafList();
    private NccGlobals globals;
    private List matched = new ArrayList();
    private LinkedList unmatched = new LinkedList();

    private void processInternalEquivRecords() {
        ArrayList newMatched = new ArrayList();
        ArrayList newUnmatched = new ArrayList();
        ListIterator it = this.unmatched.listIterator();
        while (it.hasNext()) {
            EquivRecord er = (EquivRecord)it.next();
            if (er.isLeaf()) {
                LayoutLib.error(er.isMatched(), "unmatched list has matched");
                continue;
            }
            it.remove();
            new FindLeaves(newMatched, newUnmatched, er, this.globals);
        }
        this.matched.addAll(newMatched);
        this.unmatched.addAll(newUnmatched);
    }

    public LeafEquivRecords(EquivRecord root, NccGlobals globals) {
        this.globals = globals;
        if (root == null) {
            return;
        }
        if (root.isLeaf() && root.isMatched()) {
            this.matched.add(root);
        } else {
            this.unmatched.add(root);
        }
    }

    public Iterator getUnmatched() {
        this.processInternalEquivRecords();
        return Collections.unmodifiableList(this.unmatched).iterator();
    }

    public int numUnmatched() {
        this.processInternalEquivRecords();
        return this.unmatched.size();
    }

    public Iterator getMatched() {
        this.processInternalEquivRecords();
        return Collections.unmodifiableList(this.matched).iterator();
    }

    public int numMatched() {
        this.processInternalEquivRecords();
        return this.matched.size();
    }

    private static class FindLeaves
    extends Strategy {
        private List matched;
        private List unmatched;

        public LeafList doFor(EquivRecord j) {
            if (j.isLeaf()) {
                EquivRecord er = j;
                if (er.isMatched()) {
                    this.matched.add(er);
                } else {
                    this.unmatched.add(er);
                }
            } else {
                super.doFor(j);
            }
            return EMPTY_LIST;
        }

        public FindLeaves(List newMatched, List newUnmatched, EquivRecord er, NccGlobals globals) {
            super(globals);
            this.matched = newMatched;
            this.unmatched = newUnmatched;
            this.doFor(er);
        }
    }
}

