/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.drc.CalibreDrcErrors;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class AssuraDrcErrors {
    public static void importErrors(String filename) {
        BufferedReader in;
        try {
            FileReader reader = new FileReader(filename);
            in = new BufferedReader(reader);
        }
        catch (IOException e) {
            System.out.println("Error importing DRC Errors: " + e.getMessage());
            return;
        }
        DrcRuleViolation rule = null;
        DrcError error = null;
        Cell cell = null;
        ErrorLogger logger = ErrorLogger.newInstance("Assura DRC Errors");
        int count = 0;
        int num = 1;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String[] strings = line.split("\\s+");
                if (strings.length == 0) continue;
                if (strings[0].equals("Rule") && strings.length > 4) {
                    int number = Integer.valueOf(strings[2]);
                    int remove = 9 + strings[2].length() + 3;
                    rule = new DrcRuleViolation(number, line.substring(remove, line.length()));
                    continue;
                }
                if (rule == null) continue;
                if (strings[0].equals("Real")) {
                    int real = Integer.valueOf(strings[4].replaceAll(";", ""));
                    int flat = Integer.valueOf(strings[9]);
                    rule.setErrorCounts(real, flat);
                    logger.setGroupName(rule.number, "(" + real + ") " + rule.desc);
                    num = 1;
                    continue;
                }
                if (strings[0].equals("Cell")) {
                    cell = CalibreDrcErrors.getCell(strings[3]);
                    if (cell != null) continue;
                    System.out.println("Couldn't find cell " + strings[3] + "{lay}");
                    continue;
                }
                if (cell == null) continue;
                double scale = cell.getTechnology().getScale();
                if (!strings[0].equals("Shape")) continue;
                line = in.readLine();
                line = in.readLine();
                line = in.readLine();
                while (!line.startsWith("---") && !line.startsWith("===") && (line = in.readLine()) != null) {
                    strings = line.split("\\s+");
                    if (strings.length < 6) continue;
                    int last = strings.length - 1;
                    double x1 = Double.parseDouble(strings[last - 3]) / scale * 1000.0;
                    double y1 = Double.parseDouble(strings[last - 2]) / scale * 1000.0;
                    double x2 = Double.parseDouble(strings[last - 1]) / scale * 1000.0;
                    double y2 = Double.parseDouble(strings[last]) / scale * 1000.0;
                    Rectangle2D.Double rect = new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
                    error = new DrcError(cell, rect);
                    ErrorLogger.MessageLog log = logger.logError(num + ". " + cell.getName() + ": " + rule.desc, cell, rule.number);
                    log.addLine(x1, y1, x2, y1, cell);
                    log.addLine(x1, y1, x1, y2, cell);
                    log.addLine(x2, y2, x2, y1, cell);
                    log.addLine(x2, y2, x1, y2, cell);
                    log.addLine(x1, y1, x2, y2, cell);
                    log.addLine(x1, y2, x2, y1, cell);
                    ++count;
                    ++num;
                }
            }
        }
        catch (IOException e) {
            System.out.println("Error importing DRC Errors: " + e.getMessage());
            return;
        }
        System.out.println("Imported " + count + " errors from file " + filename);
        if (count == 0) {
            JOptionPane.showMessageDialog(null, "Imported Zero Errors", "DRC Import Complete", 1);
        }
        logger.termLogging(true);
    }

    private static class DrcError {
        private final Cell cell;
        private final Shape marker;

        private DrcError(Cell cell, Shape marker) {
            this.cell = cell;
            this.marker = marker;
        }

        public Cell getCell() {
            return this.cell;
        }

        public Shape getMarker() {
            return this.marker;
        }
    }

    private static class DrcRuleViolation {
        private final int number;
        private final String desc;
        private final List errors;
        private int realErrorCount;
        private int flatErrorCount;

        private DrcRuleViolation(int number, String desc) {
            this.number = number;
            this.desc = desc;
            this.errors = new ArrayList();
        }

        private void addError(DrcError error) {
            this.errors.add(error);
        }

        public Iterator getErrors() {
            ArrayList copy = new ArrayList(this.errors);
            return copy.iterator();
        }

        private void setErrorCounts(int real, int flat) {
            this.realErrorCount = real;
            this.flatErrorCount = flat;
        }
    }
}

