/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.DBMath;
import java.io.Serializable;

public class EdgeV
implements Serializable {
    private final double multiplier;
    private final double adder;
    private final long gridAdder;

    public EdgeV(double multiplier, double adder) {
        this.multiplier = multiplier;
        this.gridAdder = DBMath.lambdaToGrid(adder);
        this.adder = DBMath.gridToLambda(this.gridAdder);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EdgeV)) {
            return false;
        }
        EdgeV otherE = (EdgeV)other;
        return this.multiplier == otherE.multiplier && this.adder == otherE.adder;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public double getAdder() {
        return this.adder;
    }

    public long getGridAdder() {
        return this.gridAdder;
    }

    public EdgeV withAdder(double adder) {
        if (this.adder == adder) {
            return this;
        }
        return new EdgeV(this.multiplier, adder);
    }

    public static EdgeV fromTop(double amt) {
        return new EdgeV(0.5, -amt);
    }

    public static EdgeV fromBottom(double amt) {
        return new EdgeV(-0.5, amt);
    }

    public static EdgeV fromCenter(double amt) {
        return new EdgeV(0.0, amt);
    }

    public static EdgeV makeBottomEdge() {
        return EdgeV.fromBottom(0.0);
    }

    public static EdgeV makeTopEdge() {
        return EdgeV.fromTop(0.0);
    }

    public static EdgeV makeCenter() {
        return EdgeV.fromCenter(0.0);
    }

    public String toString() {
        return "EdgeV(" + this.multiplier + "," + this.adder + ")";
    }
}

