/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.tool.ncc.NccPreferences;
import java.io.Serializable;

public class NccOptions
implements Serializable {
    static final long serialVersionUID = 0L;
    public static final int HIER_EACH_CELL = 0;
    public static final int FLAT_EACH_CELL = 1;
    public static final int FLAT_TOP_CELL = 2;
    public static final int LIST_ANNOTATIONS = 3;
    public int operation = 0;
    public boolean checkSizes = false;
    public double absoluteSizeTolerance;
    public double relativeSizeTolerance;
    public boolean skipPassed = false;
    public int howMuchStatus = 0;
    public boolean haltAfterFirstMismatch = true;
    public int maxMismatchedEquivRecsToPrint = 10;
    public int maxMatchedEquivRecsToPrint = 10;
    public int maxEquivRecMembersToPrint = 10;
    public boolean oneNamePerPort = true;
    public boolean checkBody = false;

    public NccOptions() {
    }

    public NccOptions(NccOptions o) {
        this.operation = o.operation;
        this.checkSizes = o.checkSizes;
        this.absoluteSizeTolerance = o.absoluteSizeTolerance;
        this.relativeSizeTolerance = o.relativeSizeTolerance;
        this.skipPassed = o.skipPassed;
        this.howMuchStatus = o.howMuchStatus;
        this.haltAfterFirstMismatch = o.haltAfterFirstMismatch;
        this.maxMismatchedEquivRecsToPrint = o.maxMismatchedEquivRecsToPrint;
        this.maxMatchedEquivRecsToPrint = o.maxMatchedEquivRecsToPrint;
        this.maxEquivRecMembersToPrint = o.maxEquivRecMembersToPrint;
        this.oneNamePerPort = o.oneNamePerPort;
        this.checkBody = o.checkBody;
    }

    public static NccOptions getOptionsFromNccPreferences() {
        NccOptions options = new NccOptions();
        options.operation = NccPreferences.getOperation();
        options.checkSizes = NccPreferences.getCheckSizes();
        options.relativeSizeTolerance = NccPreferences.getRelativeSizeTolerance() / 100.0;
        options.absoluteSizeTolerance = NccPreferences.getAbsoluteSizeTolerance();
        options.checkBody = NccPreferences.getCheckBody();
        options.skipPassed = NccPreferences.getSkipPassed();
        options.howMuchStatus = NccPreferences.getHowMuchStatus();
        options.haltAfterFirstMismatch = NccPreferences.getHaltAfterFirstMismatch();
        options.maxMismatchedEquivRecsToPrint = NccPreferences.getMaxMismatchedClasses();
        options.maxMatchedEquivRecsToPrint = NccPreferences.getMaxMatchedClasses();
        options.maxEquivRecMembersToPrint = NccPreferences.getMaxClassMembers();
        return options;
    }
}

