/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.HP6624A;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.PowerChannel;

public class HP6624AChannel
extends PowerChannel {
    private final HP6624A supply;
    private final int channel;

    public HP6624AChannel(String channelName, String supplyName, int channel) {
        HP6624A.checkChannel(channel);
        this.name = channelName + " (" + supplyName + " channel " + channel + ")";
        this.supply = new HP6624A(supplyName);
        this.channel = channel;
        HP6624AChannel.logInit("Initialized HP6624AChannel " + this.name);
    }

    public String getSupplyName() {
        return this.supply.getName();
    }

    public int getChannel() {
        return this.channel;
    }

    public String getState() {
        return this.supply.getState(this.channel);
    }

    public float readVoltage() {
        this.logOther("Reading voltage on " + this.getName());
        return this.supply.readVoltage(this.channel);
    }

    public void setVoltageNoWait(float volts) {
        this.logSet("HP6624AChannel setting voltage on " + this.getName() + " to " + volts + " V");
        this.supply.setVoltage(this.channel, volts);
    }

    public void waitForVoltage(float setVolts) {
        if (this.supply.isDisabled()) {
            return;
        }
        super.waitForVoltage(setVolts);
    }

    public float getVoltageSetpoint() {
        this.logOther("Reading voltage setpoint on " + this.getName());
        return this.supply.getVoltageSetpoint(this.channel);
    }

    public float getVoltageResolution() {
        this.logOther("Getting voltage resolution on " + this.getName());
        return HP6624A.getVoltageResolution(this.channel);
    }

    public float readCurrent() {
        this.logOther("Reading current on " + this.getName());
        return this.supply.readCurrent(this.channel);
    }

    public void setCurrent(float amps) {
        this.logSet("Setting current limit on " + this.getName() + " to " + amps);
        this.supply.setCurrent(this.channel, amps);
    }

    public float getCurrentSetpoint() {
        this.logOther("Reading current setpoint on " + this.getName());
        return this.supply.getCurrentSetpoint(this.channel);
    }

    public void setOverVoltageProtection(float setVolts) {
        this.logSet("Setting over voltage protection limit on " + this.getName() + " to " + setVolts);
        this.supply.setOverVoltageProtection(this.channel, setVolts);
    }

    public void setOverCurrentProtection(float setAmps) {
        this.logSet("Setting over current protection limit on " + this.getName() + " to " + setAmps);
        this.supply.setOverCurrentProtection(this.channel, setAmps);
    }

    public static void main(String[] args) {
        Infrastructure.gpibControllers = new int[]{1};
        HP6624AChannel[] channels = new HP6624AChannel[4];
        for (int chan = 1; chan <= 4; ++chan) {
            int ichan = chan - 1;
            channels[ichan] = new HP6624AChannel("chan" + chan, "hHP6624A", chan);
            System.out.println(chan + ": " + channels[ichan].getState());
            System.out.println("res " + channels[ichan].getVoltageResolution() + "\n");
        }
    }
}

