/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.waveform;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.util.Iterator;

public class SweepSignal {
    private Object obj;
    private WaveformWindow ww;
    private Analysis an;
    private boolean included;
    private int sweepIndex;

    public SweepSignal(Object obj, WaveformWindow ww, Analysis an) {
        this.obj = obj;
        this.ww = ww;
        this.an = an;
        this.included = true;
        this.sweepIndex = ww.addSweep(this);
    }

    public String toString() {
        String name = null;
        name = this.obj instanceof Double ? TextUtils.formatDouble((Double)this.obj) : this.obj.toString();
        if (this.included) {
            name = name + " >>>>> INCLUDED";
            if (this.ww.getHighlightedSweep() == this.sweepIndex) {
                name = name + " !!!!";
            }
        } else {
            name = name + " ----- EXCLUDED";
        }
        return name;
    }

    public void setIncluded(boolean included, boolean update) {
        if (this.included == included) {
            return;
        }
        this.included = included;
        if (update) {
            Iterator<Panel> it = this.ww.getPanels();
            while (it.hasNext()) {
                Panel wp = it.next();
                wp.repaintWithRulers();
            }
        }
    }

    public Object getObject() {
        return this.obj;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void highlight() {
        this.ww.setHighlightedSweep(this.sweepIndex);
        Iterator<Panel> it = this.ww.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            wp.repaintWithRulers();
        }
    }

    public Analysis getAnalysis() {
        return this.an;
    }
}

