/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.tool.JobException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;

public class BatchChanges {
    private static final boolean ONLY_DEFAULT_IMPL = false;
    private static BatchChanges instance;

    public static BatchChanges getInstance() {
        if (instance == null) {
            Iterator<BatchChanges> i$ = ServiceLoader.load(BatchChanges.class).iterator();
            if (i$.hasNext()) {
                BatchChanges bc;
                instance = bc = i$.next();
            }
            if (instance == null) {
                instance = new BatchChanges();
            }
        }
        return instance;
    }

    public void replaceNodeInsts(EDatabase database, Collection<NodeReplacement> replacements, boolean allowMissingPorts, EditingPreferences ep) throws JobException {
        for (NodeReplacement r : replacements) {
            NodeInst oldNode = r.getOldNi(database);
            NodeInst newNode = oldNode.doReplace(r, ep, allowMissingPorts);
            assert (newNode != null);
        }
    }

    public static class NodeReplacement
    implements Serializable {
        public final CellId cellId;
        public final int nodeId;
        public final NodeProtoId newProtoId;
        public final PrimitiveNode.Function newFunction;
        public final PortProtoId[] assoc;

        public NodeReplacement(NodeInst ni, NodeProto newProto, PrimitiveNode.Function newFunction) {
            this.cellId = ni.getParent().getId();
            this.nodeId = ni.getD().nodeId;
            this.newProtoId = newProto.getId();
            if (newFunction == null) {
                throw new NullPointerException();
            }
            this.newFunction = newFunction;
            this.assoc = new PortProtoId[ni.getNumPortInsts()];
        }

        public NodeInst getOldNi(EDatabase database) {
            return database.getCell(this.cellId).getNodeById(this.nodeId);
        }

        public void setAssoc(PortInst oldPi, PortInst newPi) {
            NodeInst oldNi = oldPi.getNodeInst();
            assert (oldNi.getParent().getId() == this.cellId);
            assert (oldNi.getD().nodeId == this.nodeId);
            this.assoc[oldPi.getPortIndex()] = newPi != null ? newPi.getPortProto().getId() : null;
        }

        public ImmutableNodeInst newImmutableInst(Snapshot snapshot, EditingPreferences ep) {
            TechPool techPool = snapshot.techPool;
            CellRevision cellRevision = snapshot.getCellRevision(this.cellId);
            ImmutableNodeInst oldD = cellRevision.getNodeById(this.nodeId);
            NodeProtoId oldProtoId = oldD.protoId;
            EPoint newSize = EPoint.ORIGIN;
            int newTechBits = 0;
            if (this.newProtoId instanceof PrimitiveNodeId) {
                PrimitiveNode pn = techPool.getPrimitiveNode((PrimitiveNodeId)this.newProtoId);
                if (oldProtoId instanceof PrimitiveNodeId) {
                    PrimitiveNode oldPn = techPool.getPrimitiveNode((PrimitiveNodeId)oldProtoId);
                    ERectangle oldBaseRect = oldPn.getBaseRectangle();
                    ERectangle newBaseRect = pn.getBaseRectangle();
                    newSize = EPoint.fromGrid(oldD.size.getGridX() + oldBaseRect.getGridWidth() - newBaseRect.getGridWidth(), oldD.size.getGridY() + oldBaseRect.getGridHeight() - newBaseRect.getGridHeight());
                } else {
                    newSize = pn.getDefSize(ep);
                }
                newTechBits = pn.getPrimitiveFunctionBits(this.newFunction);
            }
            ImmutableNodeInst newD = ImmutableNodeInst.newInstance(oldD.nodeId, this.newProtoId, oldD.name, oldD.nameDescriptor, oldD.orient, oldD.anchor, newSize, oldD.flags, newTechBits, oldD.protoDescriptor);
            Iterator<Variable> it = oldD.getVariables();
            while (it.hasNext()) {
                Variable var = it.next();
                if (var.getKey() == NodeInst.TRACE) {
                    newD = newD.withTrace((EPoint[])var.getObject(), oldD.anchor);
                    continue;
                }
                newD = newD.withVariable(var);
            }
            return newD;
        }
    }
}

