/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.S16Vector;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class U16Vector
extends SimpleVector
implements Externalizable,
Comparable {
    short[] data;

    public U16Vector() {
        this.data = S16Vector.empty;
    }

    public U16Vector(int size, short value) {
        short[] array = new short[size];
        this.data = array;
        this.size = size;
        while (--size >= 0) {
            array[size] = value;
        }
    }

    public U16Vector(int size) {
        this.data = new short[size];
        this.size = size;
    }

    public U16Vector(short[] data) {
        this.data = data;
        this.size = data.length;
    }

    public U16Vector(Sequence seq) {
        this.data = new short[seq.size()];
        this.addAll((Collection)seq);
    }

    @Override
    public int getBufferLength() {
        return this.data.length;
    }

    @Override
    public void setBufferLength(int length) {
        int oldLength = this.data.length;
        if (oldLength != length) {
            short[] tmp = new short[length];
            System.arraycopy(this.data, 0, tmp, 0, oldLength < length ? oldLength : length);
            this.data = tmp;
        }
    }

    @Override
    protected Object getBuffer() {
        return this.data;
    }

    public final short shortAt(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[index];
    }

    public final short shortAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final int intAtBuffer(int index) {
        return this.data[index] & 0xFFFF;
    }

    @Override
    public final Object get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObjectUnsigned(this.data[index]);
    }

    @Override
    public final Object getBuffer(int index) {
        return Convert.toObjectUnsigned(this.data[index]);
    }

    @Override
    public Object setBuffer(int index, Object value) {
        short old = this.data[index];
        this.data[index] = Convert.toShortUnsigned(value);
        return Convert.toObjectUnsigned(old);
    }

    public final void setShortAt(int index, short value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[index] = value;
    }

    public final void setShortAtBuffer(int index, short value) {
        this.data[index] = value;
    }

    @Override
    protected void clearBuffer(int start, int count) {
        while (--count >= 0) {
            this.data[start++] = 0;
        }
    }

    @Override
    public int getElementKind() {
        return 19;
    }

    @Override
    public String getTag() {
        return "u16";
    }

    @Override
    public boolean consumeNext(int ipos, Consumer out) {
        int index = ipos >>> 1;
        if (index >= this.size) {
            return false;
        }
        out.writeInt(this.data[index] & 0xFFFF);
        return true;
    }

    @Override
    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int i = iposStart >>> 1;
        int end = iposEnd >>> 1;
        if (end > this.size) {
            end = this.size;
        }
        while (i < end) {
            out.writeInt(this.data[i] & 0xFFFF);
            ++i;
        }
    }

    public int compareTo(Object obj) {
        return U16Vector.compareToInt(this, (U16Vector)obj);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeShort(this.data[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        short[] data = new short[size];
        for (int i = 0; i < size; ++i) {
            data[i] = in.readShort();
        }
        this.data = data;
        this.size = size;
    }
}

