/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.GenericProc;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleMethod;
import gnu.expr.Target;
import gnu.kawa.functions.MakeList;
import gnu.lists.LList;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.WrongArguments;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;

public class PrimProcedure
extends MethodProc
implements Inlineable {
    Type retType;
    Type[] argTypes;
    Method method;
    int op_code;
    boolean is_special = false;
    LambdaExp source;
    Member member;
    private static ClassLoader systemClassLoader = (class$gnu$expr$PrimProcedure == null ? (class$gnu$expr$PrimProcedure = PrimProcedure.class$("gnu.expr.PrimProcedure")) : class$gnu$expr$PrimProcedure).getClassLoader();
    static /* synthetic */ Class class$gnu$expr$PrimProcedure;

    public final int opcode() {
        return this.op_code;
    }

    public Type getReturnType() {
        return this.retType;
    }

    public void setReturnType(Type type) {
        this.retType = type;
    }

    public boolean isSpecial() {
        return this.is_special;
    }

    public Type getReturnType(Expression[] expressionArray) {
        return this.retType;
    }

    public boolean takesVarArgs() {
        if (this.method != null) {
            String string = this.method.getName();
            return string.endsWith("$V") || string.endsWith("$V$X");
        }
        return false;
    }

    public boolean takesContext() {
        return this.method != null && PrimProcedure.takesContext(this.method);
    }

    public static boolean takesContext(Method method) {
        return method.getName().endsWith("$X");
    }

    public int numArgs() {
        int n = this.argTypes.length;
        if (!this.getStaticFlag()) {
            ++n;
        }
        if (this.takesContext()) {
            --n;
        }
        return this.takesVarArgs() ? n - 1 + -4096 : n + (n << 12);
    }

    public int match0(CallContext callContext) {
        return this.matchN(ProcedureN.noArgs, callContext);
    }

    public int match1(Object object2, CallContext callContext) {
        Object[] objectArray = new Object[]{object2};
        return this.matchN(objectArray, callContext);
    }

    public int match2(Object object2, Object object3, CallContext callContext) {
        Object[] objectArray = new Object[]{object2, object3};
        return this.matchN(objectArray, callContext);
    }

    public int match3(Object object2, Object object3, Object object4, CallContext callContext) {
        Object[] objectArray = new Object[]{object2, object3, object4};
        return this.matchN(objectArray, callContext);
    }

    public int match4(Object object2, Object object3, Object object4, Object object5, CallContext callContext) {
        Object[] objectArray = new Object[]{object2, object3, object4, object5};
        return this.matchN(objectArray, callContext);
    }

    public int matchN(Object[] objectArray, CallContext callContext) {
        Object object2;
        Object object3;
        Object object4;
        int n;
        int n2 = objectArray.length;
        boolean bl = this.takesVarArgs();
        int n3 = this.minArgs() + (bl ? 1 : 0);
        int n4 = n = bl ? n3 - 1 : n3;
        if (bl) {
            if (n2 < n) {
                return 0xFFF10000 | n;
            }
        } else if (n2 != n3) {
            if (n2 < n3) {
                return 0xFFF10000 | n;
            }
            return 0xFFF20000 | n;
        }
        int n5 = this.argTypes.length;
        Type type = null;
        Object[] objectArray2 = null;
        int n6 = this.getStaticFlag() ? 0 : 1;
        boolean bl2 = this.takesContext();
        int n7 = n3 - n6;
        Object[] objectArray3 = new Object[n7 + (bl2 ? 1 : 0)];
        if (bl2) {
            objectArray3[n7] = callContext;
        }
        if (bl) {
            Type type2 = this.argTypes[n5 - 1];
            if (type2 == Compilation.scmListType) {
                objectArray3[n7 - 1] = LList.makeList(objectArray, n);
                n2 = n;
            } else {
                object4 = (ArrayType)type2;
                type = ((ArrayType)object4).getComponentType();
                object3 = type.getReflectClass();
                objectArray3[n7 - 1] = objectArray2 = (Object[])Array.newInstance(object3, n2 - n);
            }
        }
        if (n6 != 0) {
            try {
                object2 = this.method.getDeclaringClass().coerceFromObject(objectArray[0]);
            }
            catch (ClassCastException classCastException) {
                return -786432;
            }
        } else {
            object2 = null;
        }
        for (int i = n6; i < n2; ++i) {
            try {
                object4 = objectArray[i];
                Object object5 = object3 = i < n ? this.argTypes[i - n6] : type;
                if (object3 != Type.pointer_type) {
                    object4 = ((Type)object3).coerceFromObject(object4);
                }
                if (i < n) {
                    objectArray3[i - n6] = object4;
                    continue;
                }
                objectArray2[i - n] = object4;
                continue;
            }
            catch (ClassCastException classCastException) {
                return 0xFFF40000 | i;
            }
        }
        callContext.value1 = object2;
        callContext.values = objectArray3;
        callContext.proc = this;
        return 0;
    }

    public void apply(CallContext callContext) throws Throwable {
        int n = this.argTypes.length;
        boolean bl = this.op_code == 183;
        try {
            Object object2;
            if (this.member == null) {
                object2 = this.method.getDeclaringClass().getReflectClass();
                Class[] classArray = new Class[n];
                int n2 = n;
                while (--n2 >= 0) {
                    classArray[n2] = this.argTypes[n2].getReflectClass();
                }
                this.member = bl ? ((Class)object2).getConstructor(classArray) : ((Class)object2).getMethod(this.method.getName(), classArray);
            }
            object2 = bl ? ((Constructor)this.member).newInstance(callContext.values) : this.retType.coerceToObject(((java.lang.reflect.Method)this.member).invoke(callContext.value1, callContext.values));
            callContext.consumer.writeObject(object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    public PrimProcedure(java.lang.reflect.Method method, Language language) {
        this(((ClassType)language.getTypeFor(method.getDeclaringClass())).getMethod(method), language);
    }

    public PrimProcedure(Method method) {
        this.init(method);
        this.retType = method.getName().endsWith("$X") ? Type.pointer_type : method.getReturnType();
    }

    public PrimProcedure(Method method, Language language) {
        this(method, false, language);
    }

    public PrimProcedure(Method method, boolean bl, Language language) {
        this.init(method);
        Type[] typeArray = method.getParameterTypes();
        int n = typeArray.length;
        this.argTypes = null;
        int n2 = n;
        while (--n2 >= 0) {
            Type type;
            Type type2 = typeArray[n2];
            if (type2 instanceof ClassType && !((ClassType)type2).isExisting() || type2 == (type = language.getTypeFor(type2.getReflectClass()))) continue;
            if (this.argTypes == null) {
                this.argTypes = new Type[n];
                System.arraycopy(typeArray, 0, this.argTypes, 0, n);
            }
            this.argTypes[n2] = type;
        }
        if (this.argTypes == null) {
            this.argTypes = typeArray;
        }
        if (this.op_code == 183 && !bl) {
            this.retType = method.getDeclaringClass();
        } else if (method.getName().endsWith("$X")) {
            this.retType = Type.pointer_type;
        } else {
            this.retType = method.getReturnType();
            if (!(this.retType instanceof ClassType) || ((ClassType)this.retType).isExisting()) {
                this.retType = language.getTypeFor(this.retType.getReflectClass());
            }
            if (this.retType == Type.tostring_type) {
                this.retType = Type.string_type;
            }
        }
        if (bl) {
            this.is_special = true;
            this.op_code = 183;
        }
    }

    private void init(Method method) {
        ClassType classType;
        this.method = method;
        this.argTypes = method.getParameterTypes();
        int n = method.getModifiers();
        this.op_code = (n & 8) != 0 ? 184 : (((classType = method.getDeclaringClass()).getModifiers() & 0x200) != 0 ? 185 : ("<init>".equals(method.getName()) ? 183 : 182));
    }

    public PrimProcedure(Method method, LambdaExp lambdaExp) {
        this(method);
        this.retType = lambdaExp.getReturnType();
        this.source = lambdaExp;
    }

    public PrimProcedure(int n, Type type, Type[] typeArray) {
        this.op_code = n;
        this.retType = type;
        this.argTypes = typeArray;
    }

    public static PrimProcedure makeBuiltinUnary(int n, Type type) {
        Type[] typeArray = new Type[]{type};
        return new PrimProcedure(n, type, typeArray);
    }

    public static PrimProcedure makeBuiltinBinary(int n, Type type) {
        Type[] typeArray = new Type[]{type, type};
        return new PrimProcedure(n, type, typeArray);
    }

    public PrimProcedure(int n, ClassType classType, String string, Type type, Type[] typeArray) {
        this.op_code = n;
        this.method = classType.addMethod(string, n == 184 ? 8 : 0, typeArray, type);
        this.retType = type;
        this.argTypes = typeArray;
    }

    public PrimProcedure(ClassType classType, Type[] typeArray) {
        this(183, classType, "<init>", Type.void_type, typeArray);
        this.retType = classType;
    }

    public final boolean getStaticFlag() {
        return this.method == null || this.method.getStaticFlag() || this.op_code == 183 && !this.is_special;
    }

    public final Type[] getParameterTypes() {
        return this.argTypes;
    }

    void compileArgs(Expression[] expressionArray, Type type, Compilation compilation) {
        Declaration declaration;
        boolean bl = this.takesVarArgs();
        String string = this.getName();
        Type type2 = null;
        CodeAttr codeAttr = compilation.getCode();
        int n = type == Type.void_type ? 1 : 0;
        int n2 = this.argTypes.length - n;
        if (this.takesContext()) {
            --n2;
        }
        boolean bl2 = type == null || n != 0;
        int n3 = bl ? n2 - 1 : expressionArray.length;
        Declaration declaration2 = declaration = this.source == null ? null : this.source.firstDecl();
        if (declaration != null && declaration.isThisParameter()) {
            declaration = declaration.nextDecl();
        }
        int n4 = 0;
        while (true) {
            if (bl && n4 == n3) {
                type2 = this.argTypes[n2 - 1 + n];
                if (type2 == Compilation.scmListType) {
                    MakeList.compile(expressionArray, n4, compilation);
                    break;
                }
                codeAttr.emitPushInt(expressionArray.length - n3);
                type2 = ((ArrayType)type2).getComponentType();
                codeAttr.emitNewArray(type2);
            }
            if (n4 >= expressionArray.length) break;
            if (n4 >= n3) {
                codeAttr.emitDup(1);
                codeAttr.emitPushInt(n4 - n3);
            } else {
                type2 = declaration != null && (bl2 || n4 > 0) ? declaration.getType() : (bl2 ? this.argTypes[n4 + n] : (n4 == 0 ? type : this.argTypes[n4 - 1]));
            }
            compilation.usedClass(type2);
            Target target = this.source == null ? CheckedTarget.getInstance(type2, string, n4 + 1) : CheckedTarget.getInstance(type2, this.source, n4);
            expressionArray[n4].compileNotePosition(compilation, target, expressionArray[n4]);
            if (n4 >= n3) {
                codeAttr.emitArrayStore(type2);
            }
            if (declaration != null && (bl2 || n4 > 0)) {
                declaration = declaration.nextDecl();
            }
            ++n4;
        }
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        Expression[] expressionArray;
        String string;
        ClassType classType;
        CodeAttr codeAttr = compilation.getCode();
        ClassType classType2 = classType = this.method == null ? null : this.method.getDeclaringClass();
        if (this.opcode() == 183 && !this.is_special) {
            codeAttr.emitNew(classType);
            codeAttr.emitDup(classType);
        }
        if ((string = WrongArguments.checkArgCount(this, (expressionArray = applyExp.getArgs()).length)) != null) {
            compilation.error('e', string);
        }
        this.compile(this.getStaticFlag() ? null : classType, applyExp, compilation, target);
    }

    public void compile(Type type, ApplyExp applyExp, Compilation compilation, Target target) {
        Expression[] expressionArray = applyExp.getArgs();
        CodeAttr codeAttr = compilation.getCode();
        Type type2 = this.retType;
        this.compileArgs(expressionArray, type, compilation);
        if (this.method == null) {
            codeAttr.emitPrimop(this.opcode(), expressionArray.length, this.retType);
            target.compileFromStack(compilation, type2);
        } else {
            PrimProcedure.compile(compilation, this.method, target, applyExp.isTailCall(), this.op_code, type2);
        }
    }

    public static void compile(Compilation compilation, Method method, Target target, boolean bl, int n, Type type) {
        CodeAttr codeAttr = compilation.getCode();
        compilation.usedClass(method.getDeclaringClass());
        compilation.usedClass(method.getReturnType());
        if (!PrimProcedure.takesContext(method)) {
            codeAttr.emitInvokeMethod(method, n);
        } else {
            if (target instanceof IgnoreTarget || target instanceof ConsumerTarget && ((ConsumerTarget)target).isContextTarget()) {
                compilation.loadCallContext();
                codeAttr.emitInvokeMethod(method, n);
                if (bl) {
                    compilation.loadCallContext();
                    codeAttr.emitInvoke(Compilation.typeCallContext.getDeclaredMethod("runUntilDone", 0));
                }
                return;
            }
            compilation.loadCallContext();
            type = Type.pointer_type;
            codeAttr.pushScope();
            Variable variable = codeAttr.addLocal(Type.int_type);
            compilation.loadCallContext();
            codeAttr.emitInvokeVirtual(Compilation.typeCallContext.getDeclaredMethod("startFromContext", 0));
            codeAttr.emitStore(variable);
            codeAttr.emitWithCleanupStart();
            codeAttr.emitInvokeMethod(method, n);
            codeAttr.emitWithCleanupCatch(null);
            compilation.loadCallContext();
            codeAttr.emitLoad(variable);
            codeAttr.emitInvokeVirtual(Compilation.typeCallContext.getDeclaredMethod("cleanupFromContext", 1));
            codeAttr.emitWithCleanupDone();
            compilation.loadCallContext();
            codeAttr.emitLoad(variable);
            codeAttr.emitInvokeVirtual(Compilation.typeCallContext.getDeclaredMethod("getFromContext", 1));
            codeAttr.popScope();
        }
        target.compileFromStack(compilation, type);
    }

    public Type getParameterType(int n) {
        int n2;
        if (!this.getStaticFlag()) {
            if (n == 0) {
                return this.method.getDeclaringClass();
            }
            --n;
        }
        if (n < (n2 = this.argTypes.length) - 1) {
            return this.argTypes[n];
        }
        boolean bl = this.takesVarArgs();
        if (n < n2 && !bl) {
            return this.argTypes[n];
        }
        Type type = this.argTypes[n2 - 1];
        if (type instanceof ArrayType) {
            return ((ArrayType)type).getComponentType();
        }
        return Type.pointer_type;
    }

    public static PrimProcedure getMethodFor(Procedure procedure, Expression[] expressionArray) {
        return PrimProcedure.getMethodFor(procedure, null, expressionArray, Language.getDefaultLanguage());
    }

    public static PrimProcedure getMethodFor(Procedure procedure, Declaration declaration, Expression[] expressionArray, Language language) {
        int n = expressionArray.length;
        Type[] typeArray = new Type[n];
        int n2 = n;
        while (--n2 >= 0) {
            typeArray[n2] = expressionArray[n2].getType();
        }
        return PrimProcedure.getMethodFor(procedure, declaration, typeArray, language);
    }

    public static PrimProcedure getMethodFor(Procedure procedure, Declaration declaration, Type[] typeArray, Language language) {
        Object object2;
        if (procedure instanceof GenericProc) {
            object2 = (GenericProc)procedure;
            MethodProc[] methodProcArray = ((GenericProc)object2).methods;
            procedure = null;
            int n = ((GenericProc)object2).count;
            while (--n >= 0) {
                int n2 = methodProcArray[n].isApplicable(typeArray);
                if (n2 < 0) continue;
                if (procedure != null) {
                    return null;
                }
                procedure = methodProcArray[n];
            }
            if (procedure == null) {
                return null;
            }
        }
        if (procedure instanceof PrimProcedure && ((MethodProc)(object2 = (PrimProcedure)procedure)).isApplicable(typeArray) >= 0) {
            return object2;
        }
        object2 = PrimProcedure.getProcedureClass(procedure);
        if (object2 == null) {
            return null;
        }
        return PrimProcedure.getMethodFor((ClassType)Type.make((Class)object2), procedure.getName(), declaration, typeArray, language);
    }

    public static Class getProcedureClass(Object object2) {
        Class<?> clazz = object2 instanceof ModuleMethod ? ((ModuleMethod)object2).module.getClass() : object2.getClass();
        try {
            if (clazz.getClassLoader() == systemClassLoader) {
                return clazz;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static PrimProcedure getMethodFor(Class clazz, String string, Declaration declaration, Expression[] expressionArray, Language language) {
        return PrimProcedure.getMethodFor((ClassType)Type.make(clazz), string, declaration, expressionArray, language);
    }

    public static PrimProcedure getMethodFor(ClassType classType, String string, Declaration declaration, Expression[] expressionArray, Language language) {
        int n = expressionArray.length;
        Type[] typeArray = new Type[n];
        int n2 = n;
        while (--n2 >= 0) {
            typeArray[n2] = expressionArray[n2].getType();
        }
        return PrimProcedure.getMethodFor(classType, string, declaration, typeArray, language);
    }

    public static PrimProcedure getMethodFor(ClassType classType, String string, Declaration declaration, Type[] typeArray, Language language) {
        PrimProcedure primProcedure = null;
        int n = -1;
        boolean bl = false;
        try {
            if (string == null) {
                return null;
            }
            String string2 = Compilation.mangleName(string);
            String string3 = string2 + "$V";
            String string4 = string2 + "$V$X";
            String string5 = string2 + "$X";
            boolean bl2 = true;
            for (Method method = classType.getDeclaredMethods(); method != null; method = method.getNext()) {
                boolean bl3;
                int n2 = method.getModifiers();
                if ((n2 & 9) != 9 && (declaration == null || declaration.base == null)) continue;
                String string6 = method.getName();
                if (string6.equals(string2) || string6.equals(string3) || string6.equals(string5) || string6.equals(string4)) {
                    bl3 = false;
                } else {
                    if (!bl2 || !string6.equals("apply") && !string6.equals("apply$V")) continue;
                    bl3 = true;
                }
                if (!bl3) {
                    bl2 = false;
                    if (bl) {
                        primProcedure = null;
                        n = -1;
                        bl = false;
                    }
                }
                PrimProcedure primProcedure2 = new PrimProcedure(method, language);
                primProcedure2.setName(string);
                int n3 = primProcedure2.isApplicable(typeArray);
                if (n3 < 0 || n3 < n) continue;
                if (n3 > n) {
                    primProcedure = primProcedure2;
                } else if (primProcedure != null && (primProcedure = (PrimProcedure)MethodProc.mostSpecific(primProcedure, primProcedure2)) == null && n > 0) {
                    return null;
                }
                n = n3;
                bl = bl3;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return primProcedure;
    }

    public String getName() {
        String string = super.getName();
        if (string != null) {
            return string;
        }
        string = this.getVerboseName();
        this.setName(string);
        return string;
    }

    public String getVerboseName() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.method == null) {
            stringBuffer.append("<op ");
            stringBuffer.append(this.op_code);
            stringBuffer.append('>');
        } else {
            stringBuffer.append(this.method.getDeclaringClass().getName());
            stringBuffer.append('.');
            stringBuffer.append(this.method.getName());
        }
        stringBuffer.append('(');
        for (int i = 0; i < this.argTypes.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.argTypes[i].getName());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.retType.getName());
        stringBuffer.append(' ');
        stringBuffer.append(this.getVerboseName());
        return stringBuffer.toString();
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<primitive procedure ");
        printWriter.print(this.toString());
        printWriter.print('>');
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

