import QtQuick
import QtQuick.VirtualKeyboard
import QtQuick.VirtualKeyboard.Styles

KeyPanel {
    id: root

    Rectangle {
        id: keyboardBasicKey
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom

        //determines the spacing between the keys
        anchors.topMargin: 6
        anchors.bottomMargin: 6
        anchors.leftMargin: 6
        anchors.rightMargin: 6
        color: "#5E5E5E"
        radius: 24
        border.color: "#222840"
        border.width: 1
        z: 1

        GlowRectangle {
            id: glowRectangleID
            anchors.fill: keyboardBasicKey
            glowRectRadius: keyboardBasicKey.radius
            z: 2
            visible: root.control.pressed
        }

        Text {
            id: keyLabel
            width: 111
            height: 110
            color: "#FAFAFA"
            text: root.control.displayText
            font.pixelSize: 36
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            wrapMode: Text.Wrap
            font.bold: false
            font.weight: Font.Normal
            font.italic: false
            font.family: "Inter"
            anchors.centerIn: parent

            font.capitalization: root.control.uppercased ? Font.AllUppercase : Font.AllLowercase
        }
    }
}

/*##^##
Designer {
    D{i:0;uuid:"bbcf08e6-1aef-517b-9e5d-b58f9cf56e3b"}
}
##^##*/

