import QtQuick
import QtQuick3D
import Generated.QtQuick3D.Demo_City_Buildings 1.0
import Generated.QtQuick3D.Demo_City_Ground 1.0
import QtQuick.Timeline 1.0
import QtQuick 2.15

Node{
    id:root
    property real b:0
    property real m:0
    property real d:0
    property bool n: false
    property bool city: false
    property color skycolor: "black"
    Model {

    id: terrain
    rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
    scale.x: 100
    scale.y: 100
    scale.z: 100
    source: "meshes/plane.mesh"
    materials: [terrainmaterial,defaultMaterial]

    CustomMaterial {
        id: terrainmaterial
        property real bend: b
        property real move: m
        property real dayt: d
        property color sky: skycolor
        property TextureInput desertTexture: TextureInput {
            texture: Texture {
                source: "../../../images/terrainlines.jpg"
                generateMipmaps: true
                mipFilter: Texture.Linear
            }
        }
        property TextureInput desertTextureDay: TextureInput {
            texture: Texture {
                source: "../../../images/terrainlineslight.jpg"
                mipFilter: Texture.Linear
                magFilter: Texture.Nearest
                generateMipmaps: true
            }
        }
        property TextureInput mask: TextureInput {
            texture: Texture {
                source: "../../../images/speedmask.png"
                magFilter: Texture.Nearest
                mipFilter: Texture.Nearest
                generateMipmaps: true
            }
        }
        lightProbe: blockGradient
        depthDrawMode: Material.AlwaysDepthDraw
        cullMode: Material.BackFaceCulling
        alwaysDirty: false
        destinationBlend: CustomMaterial.OneMinusSrcAlpha
        sourceBlend: CustomMaterial.SrcAlpha
        vertexShader: "../../../Outrun_ClusterContent/desert.vert"
        fragmentShader: "../../../Outrun_ClusterContent/desert.frag"

        Texture {
            id: blockGradient
            source: "../../../images/BlockGradient.hdr"
            generateMipmaps: true
            mappingMode: Texture.LightProbe
        }
    }

    DefaultMaterial {
        id: defaultMaterial
        blendMode: DefaultMaterial.Multiply
        specularReflectionMap: blockGradient
        diffuseColor: "#4aee45"
    }
    states: [
        State {
            name: "Day"
            when: n == false

            PropertyChanges {
                target: terrainmaterial
                dayt: 1
            }
        },
        State {
            name: "Night"
            when: n == true
            PropertyChanges {
                target: terrainmaterial
                dayt: 0
            }
        }
    ]
    transitions: Transition {
        NumberAnimation {
            properties: "dayt"
            easing.type: Easing.Linear
            duration: 1000
        }
    }


    }

    Demo_City_Ground {
        id: demo_City_Ground
        x: 0
        y: -53.625
        opacity: 0
        visible: true
        night: night
        z: 0
        scale.z: 15.39493
        scale.y: 1
        scale.x: 0.4
        eulerRotation.y: -90
    }

    Demo_City_Buildings {
        id: demo_City_Buildings
        opacity: 0
        scale.z: 2
        scale.y: 1.5
        scale.x: 0.4
        eulerRotation.y: -90
        night: n
    }

    Timeline {
        id: envStates
        animations: [
            TimelineAnimation {
                id: desertAnim
                loops: 1
                running: false
                duration: 1000
                to: 1000
                from: 0
            },
            TimelineAnimation {
                id: cityAnim
                loops: 1
                running: false
                duration: 1000
                to: 1000
                from: 0
            }
        ]
        endFrame: 1000
        startFrame: 0
        enabled: false
    }

    Timeline {
        id: envStates2
        animations: [
            TimelineAnimation {
                id: cityAnim2
                loops: 1
                running: false
                duration: 1000
                to: 1000
                from: 0
            }
        ]
        endFrame: 1000
        startFrame: 0
        enabled: false
    }

    Model {
        id: plane
        visible: false
        source: "#Rectangle"
        DefaultMaterial {
            id: rectMaterial
            diffuseColor: "#4aee45"
        }
        materials: rectMaterial
    }
    states: [
        State {
            name: "desert"
            when: city == false


            PropertyChanges {
                target: envStates
                enabled: true
            }

            PropertyChanges {
                target: desertAnim
                running: true
            }

            PropertyChanges {
                target: terrain
                opacity: 1
            }

            PropertyChanges {
                target: demo_City_Buildings
                y: -124.91
                opacity: 1
                visible: false
                scale.x: 1
            }

            PropertyChanges {
                target: demo_City_Ground
                opacity: 0
                visible: false
            }


        },
        State {
            name: "city"
            when: city == true


            PropertyChanges {
                target: envStates
                enabled: false
            }

            PropertyChanges {
                target: cityAnim
                running: true
            }

            PropertyChanges {
                target: envStates2
                enabled: true
            }

            PropertyChanges {
                target: cityAnim2
                running: true
            }

            PropertyChanges {
                target: demo_City_Buildings
                x: -0
                y: -15.99
                opacity: 1
                eulerRotation.x: 0
                scale.z: 1.2
                night: night
                scale.x: 1.8
                z: -1275.07544
            }

            PropertyChanges {
                target: demo_City_Ground
                x: 0
                y: 5.908
                opacity: 1
                visible: true
                scale.z: 0.43325
                scale.x: 0.4
                z: 0.00001
            }

            PropertyChanges {
                target: plane
                x: -0
                y: -1.327
                visible: false
                z: 19911.24023
                eulerRotation.x: -90
                scale.y: 403.32889
                scale.x: 16.26019
                scale.z: 1
            }

            PropertyChanges {
                target: rectMaterial
                diffuseColor: "#735f7d"
            }

            PropertyChanges {
                target: terrain
                opacity: 0
            }
        }
    ]


}
