import QtQuick
import QtQuick3D
import QtQuick 2.15
Model {
    id: baseroad
    property bool night: false
    property bool fakeReflections: true
    rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
    scale.x: 100
    scale.y: 100
    scale.z: 100
    source: "meshes/lanes.mesh"
    opacity: fakeReflections ? 0.9 : 1

    materials: fakeReflections ? [asphalt] : [reflectiveAsphalt]

    CustomMaterial {
        id: asphalt
        property color materialColor: "#232323"
        lightProbe: car_ref1
        depthDrawMode: Material.AlwaysDepthDraw
        destinationBlend: CustomMaterial.OneMinusSrcAlpha
        sourceBlend: CustomMaterial.SrcAlpha
        shadingMode: CustomMaterial.Shaded

        fragmentShader: "../../../Outrun_ClusterContent/asphalt.frag"

        Texture {
            id: car_ref1
            source: "../../../images/car_ref1.png"
            mappingMode: Texture.LightProbe
        }
    }

    CustomMaterial {
        id: reflectiveAsphalt
        property color materialColor: "#232323"
        property double rayMaxDistance: 600
        property int marchSteps: 600
        property int refinementSteps: 10
        property double depthBias: 0.6
        property double specular: 0.5
        lightProbe: car_ref1
        depthDrawMode: Material.AlwaysDepthDraw
        destinationBlend: CustomMaterial.OneMinusSrcAlpha
        sourceBlend: CustomMaterial.SrcAlpha
        shadingMode: CustomMaterial.Unshaded

        fragmentShader: "../../../Outrun_ClusterContent/screenspacereflections.frag"
    }

    states: [
        State {
            name: "night"
            when: night == true

            PropertyChanges {
                target: fakeReflections ? asphalt : reflectiveAsphalt
                materialColor: "#07021F"
            }

            PropertyChanges {
                target: baseroad
                opacity: 0.9
            }
        },
        State {
            name: "day"
            when: night == false

            PropertyChanges {
                target: fakeReflections ? asphalt : reflectiveAsphalt
                materialColor: "#666571"
            }

            PropertyChanges {
                target: baseroad
                opacity: 0.7
            }
        }
    ]
    transitions: Transition {
        ColorAnimation {
            properties: "materialColor"
            easing.type: Easing.InOutQuad
            duration: 2000
        }
    }
}
