
/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Quick Studio Components.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
import QtQuick
import QtQuick.Controls
import QtQuick3D
import Simple3D
import Generated.QtQuick3D.Example 1.0
import QtQuick3D.Effects 6.0
import Generated.QtQuick3D.TimeMachineQT 1.0
import QtQuick.Studio.Effects 1.0
import QtQuick.Studio.Components 1.0

Rectangle {
    id: rectangle1
    width: Constants.width
    height: Constants.height
    color: "#002a2a2a"



    Image {
        id: image
        visible: true
        anchors.fill: parent
        source: "images/bg2.png"
        fillMode: Image.Stretch
    }

    MouseArea {
        id: mouseArea
        property real mouseXprev: 0
        property real rotationY: 45
        anchors.fill: parent

        hoverEnabled: true

        Connections {
            target: mouseArea
            onMouseXChanged: {
                if (mouseArea.pressed) {
                    mouseArea.rotationY += (mouseArea.mouseX - mouseArea.mouseXprev) / 5
                }
                mouseArea.mouseXprev = mouseArea.mouseX
            }
        }
    }

    View3D {
        id: timemachineQT
        visible: true
        anchors.fill: parent

        environment: sceneEnvironment

        SceneEnvironment {
            id: sceneEnvironment
            effects: [hDRBloomTonemap,motionBlur]
            tonemapMode: SceneEnvironment.TonemapModeHejlDawson
            clearColor: "#000000"
            backgroundMode: SceneEnvironment.Transparent
            probeExposure: 1.5
            antialiasingMode: SceneEnvironment.MSAA
            antialiasingQuality: SceneEnvironment.VeryHigh

            HDRBloomTonemap {
                id: hDRBloomTonemap
                bloomThreshold: 0.9
            }

            MotionBlur {
                id: motionBlur
                blurQuality: 1
                fadeAmount: 0.7
            }
        }

        Node {
            id: scene

            PerspectiveCamera {
                id: sceneCamera
                fieldOfView: 59
                z: 350
            }

            TimeMachineQT {
                id: timeMachineQT
                eulerRotation.y: mouseArea.rotationY
                scale.z: 0.6
                scale.y: 0.6
                scale.x: 0.6
            }

            SpotLight {
                id: lightSpot
                x: -0
                y: 0
                color: "#5eff01"
                shadowMapFar: 21500
                constantFade: 6.2
                linearFade: 5.1
                quadraticFade: 1.5
                shadowMapQuality: Light.ShadowMapQualityVeryHigh
                shadowFilter: 1
                shadowFactor: 38
                shadowBias: 0.2
                castsShadow: true
                brightness: 7.46
                coneAngle: 176
                innerConeAngle: 131
                z: 48.20878
            }

        }
    }

    RectangleItem {
        id: rectangle
        opacity: 0.5
        anchors.fill: parent
        strokeColor: "#3e3e3e"
        layer.enabled: true
        dashPattern: [0.1,5,0,0]
        strokeStyle: 2
        anchors.bottomMargin: 23
        anchors.leftMargin: 31
        anchors.rightMargin: 31
        anchors.topMargin: 23
        fillColor: "#00000000"
    }

    Image {
        id: drag_icon
        opacity: 0.3
        anchors.fill: parent
        source: "images/drag_icon.png"
        sourceSize.height: 200
        sourceSize.width: 200
        anchors.bottomMargin: 23
        anchors.leftMargin: 475
        anchors.rightMargin: 475
        anchors.topMargin: 558
        antialiasing: true
        layer.enabled: true
        layer.effect: ColorOverlayEffect {
            id: colorOverlay
            color: "#5b5b5b"
            cached: true
        }
        fillMode: Image.PreserveAspectFit
    }

    Item {
        id: __materialLibrary__
    }





}

/*##^##
Designer {
    D{i:8;cameraSpeed3d:25;cameraSpeed3dMultiplier:1}
}
##^##*/
