
// Created with Qt Design Studio (version 4.7.0), Thu Nov 14 16:07:34 2024
// Do not manually edit this file, it will be overwritten if effect is modified in Qt Design Studio.

import QtQuick

Item {
    id: rootItem

    // Use visible property to show and hide the effect.
    visible: true

    // This is an internal property used by tooling to identify effect items. Do not modify.
    property bool _isEffectItem

    // This is an internal property used to manage the effect. Do not modify.
    property Item _oldParent: null

    // This is the main source for the effect. Set internally to the current parent item. Do not modify.
    property Item source: null
    // Enable this to animate iTime property
    property bool timeRunning: true
    // When timeRunning is false, this can be used to control iTime manually
    property real animatedTime: frameAnimation.elapsedTime

    function setupParentLayer()
    {
        if (_oldParent && _oldParent !== parent) {
            _oldParent.layer.enabled = false
            _oldParent.layer.effect = null
            
            source = null
            _oldParent.update()
            _oldParent = null
        }
        if (parent) {
            _oldParent = parent
            if (visible) {
                parent.layer.enabled = true
                parent.layer.effect = effectComponent
                
                source = parent
            } else {
                parent.layer.enabled = false
                parent.layer.effect = null
                
                source = null
            }
            parent.update()
        }

        setupLayer_rainTexture()
    }

    onParentChanged: setupParentLayer()

    onVisibleChanged: setupParentLayer()

    // Color used for the thunder strikes.
    property color thunderColor: "#80ffe6cc"
    // Defines how often the strikes occur. Values are between 0 (never) and 1 (every time).
    property real thunderStrikeOccurrence: 0.07
    // Texture for the rain effect. This should support seamless tiling.
    property var rainTexture: imageItemrainTexture
    // The amount of rain layers. Increasing the layers adds variation to the rain effect but also requires more processing power. The default value is 4 and practical range is between 1 and 10.
    property int rainLayers: 6
    // Scaling of the rain texture. Values of x and y define scaling of the first rain layer and values z and w define the scaling step size of each following rain layer. So if values of z and w are 0.0, all rain layers have the same size.
    property vector4d rainTextureScale: Qt.vector4d(1, 0.5, 0.2, 0.1)
    // Defines wind direction for the rain. The default value is 0.0 and practical range is between -1.0 and 1.0.
    property real rainWind: -0.13
    // Defines the color of the rain. The default value is light blue (0.8, 0.8, 1.0, 1.0).
    property color rainColor: "#ccccff"

    FrameAnimation {
        id: frameAnimation
        running: rootItem.timeRunning
    }


    property var oldRainTexture: null
    function setupLayer_rainTexture()
    {
        if (oldRainTexture) {
            oldRainTexture.layer.enabled = false
            oldRainTexture = null
        }
        if (rainTexture != imageItemrainTexture) {
            rainTexture.layer.enabled = true
            oldRainTexture = rainTexture
        }
    }
    onRainTextureChanged: setupLayer_rainTexture()
    property url rainTextureUrl: "rain.png"
    Image {
        id: imageItemrainTexture
        anchors.fill: parent
        source: rootItem.rainTextureUrl
        visible: false
    }
    Component {
        id: effectComponent
        ShaderEffect {
            property Item source: null
            readonly property Item iSource: rootItem.source
            readonly property real iTime: rootItem.animatedTime
            readonly property color thunderColor: rootItem.thunderColor
            readonly property real thunderStrikeOccurrence: rootItem.thunderStrikeOccurrence
            readonly property var rainTexture: rootItem.rainTexture
            readonly property int rainLayers: rootItem.rainLayers
            readonly property vector4d rainTextureScale: rootItem.rainTextureScale
            readonly property real rainWind: rootItem.rainWind
            readonly property color rainColor: rootItem.rainColor

            vertexShader: 'thunderraineffect.vert.qsb'
            fragmentShader: 'thunderraineffect.frag.qsb'
            anchors.fill: rootItem.source
        }
    }
}
